/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.rsq.component.exception;

import java.sql.SQLException;
import org.hibernate.internal.util.JdbcExceptionHelper;

public class OracleErrorCode {
    public static String translate(SQLException ex) {
        int n = JdbcExceptionHelper.extractErrorCode((SQLException)ex);
        if (n == 30006) {
            return "ORA-30006 LockTimeoutException : resource busy; acquire with WAIT timeout expired";
        }
        if (n == 54) {
            return "ORA-00054 LockTimeoutException : resource busy and acquire with NOWAIT specified or timeout expired";
        }
        if (4021 == n) {
            return "ORA-04021 LockTimeoutException : timeout occurred while waiting to lock object";
        }
        if (60 == n) {
            return "ORA-00060 LockAcquisitionException : deadlock detected while waiting for resource";
        }
        if (4020 == n) {
            return "ORA-04020 LockAcquisitionException : deadlock detected while trying to lock object";
        }
        if (1013 == n) {
            return "ORA-01013 QueryTimeoutException : user requested cancel of current operation";
        }
        if (1407 == n) {
            return "ORA-01407 ConstraintViolationException : cannot update column to NULL";
        }
        return ex.getMessage();
    }
}

