/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.rsq.component.exception;

import cn.patterncat.rest.ApiResult;
import cn.patterncat.rsq.component.exception.InvalidAccessException;
import cn.patterncat.rsq.component.exception.MvcExceptionAdvice;
import cn.patterncat.rsq.component.exception.OracleErrorCode;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.core.NestedRuntimeException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.validation.BindException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.context.request.async.AsyncRequestTimeoutException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
@ConditionalOnClass(value={RestControllerAdvice.class})
@ConditionalOnMissingBean(value={MvcExceptionAdvice.class})
@ConditionalOnWebApplication
public class DefaultMvcExceptionAdvice {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMvcExceptionAdvice.class);
    @Value(value="${spring.datasource.rsq.databaseType}")
    Database databaseType;

    @ExceptionHandler(value={MissingServletRequestParameterException.class, ServletRequestBindingException.class, TypeMismatchException.class, HttpMessageNotReadableException.class, MethodArgumentNotValidException.class, MissingServletRequestPartException.class, InvalidAccessException.class, IllegalArgumentException.class, BindException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseEntity<ApiResult> badRequestException(Exception ex) {
        LOGGER.warn(ex.getMessage(), (Throwable)ex);
        return ResponseEntity.badRequest().body((Object)ApiResult.fail((String)ex.getMessage()));
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.METHOD_NOT_ALLOWED)
    public ResponseEntity<ApiResult> notSupportException(Exception e) {
        return ResponseEntity.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED).body((Object)ApiResult.fail((String)e.getMessage()));
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ResponseEntity<ApiResult> notFoundException(Exception ex) {
        return ResponseEntity.notFound().build();
    }

    @ExceptionHandler(value={PersistenceException.class, SQLException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ResponseEntity<ApiResult> sqlException(Exception e) {
        LOGGER.error(e.getMessage(), (Throwable)e);
        if (e instanceof SQLException && Database.ORACLE == this.databaseType) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)ApiResult.fail((String)OracleErrorCode.translate((SQLException)e)));
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)ApiResult.fail((String)e.getMessage()));
    }

    @ExceptionHandler(value={ConversionNotSupportedException.class, HttpMessageNotWritableException.class, HttpClientErrorException.class, NestedRuntimeException.class, SQLException.class, AsyncRequestTimeoutException.class, Throwable.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ResponseEntity<ApiResult> internalServerError(Throwable ex) {
        if (ex instanceof HttpClientErrorException) {
            String string = new String(((HttpClientErrorException)ex).getResponseBodyAsByteArray(), StandardCharsets.UTF_8);
            LOGGER.error(string, ex);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)ApiResult.fail((String)string));
        }
        LOGGER.error(ex.getMessage(), ex);
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)ApiResult.fail((String)ex.getMessage()));
    }
}

