/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.qrcode.core.writer;

import cn.patterncat.qrcode.core.bean.BitMatrixInfo;
import cn.patterncat.qrcode.core.writer.DefaultQrCodeWriterQrCode;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.QRCode;

public class StrictQuietZoneWriterQrCode
extends DefaultQrCodeWriterQrCode {
    @Override
    public BitMatrixInfo renderResult(QRCode code, int width, int height, int quietZone) {
        ByteMatrix input = code.getMatrix();
        if (input == null) {
            throw new IllegalStateException();
        }
        int inputWidth = input.getWidth();
        int inputHeight = input.getHeight();
        if (width < inputWidth || height < inputHeight) {
            throw new IllegalArgumentException("target img size cannot contain target msg");
        }
        int outputWidth = width;
        int outputHeight = height;
        int qrWidth = inputWidth;
        int qrHeight = inputHeight;
        int multiple = Math.min((outputWidth - quietZone * 2) / qrWidth, (outputHeight - quietZone * 2) / qrHeight);
        int leftPadding = (outputWidth - inputWidth * multiple) / 2;
        int topPadding = (outputHeight - inputHeight * multiple) / 2;
        BitMatrixInfo bitMatrixInfo = this.buildOutputMatrixInfo(code, outputWidth, outputHeight, multiple, topPadding, leftPadding);
        return bitMatrixInfo;
    }
}

