/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.qrcode.core.writer;

import cn.patterncat.qrcode.core.bean.BitMatrixInfo;
import cn.patterncat.qrcode.core.writer.QrCodeMatrixWriter;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.Encoder;
import com.google.zxing.qrcode.encoder.QRCode;
import java.util.Map;

public class DefaultQrCodeWriterQrCode
implements QrCodeMatrixWriter {
    public static final int QUIET_ZONE_SIZE = 4;

    @Override
    public BitMatrixInfo encode(String contents, BarcodeFormat format, int width, int height) throws WriterException {
        return this.encode(contents, format, width, height, null);
    }

    @Override
    public BitMatrixInfo encode(String contents, BarcodeFormat format, int width, int height, Map<EncodeHintType, ?> hints) throws WriterException {
        if (contents.isEmpty()) {
            throw new IllegalArgumentException("Found empty contents");
        }
        if (format != BarcodeFormat.QR_CODE) {
            throw new IllegalArgumentException("Can only encode QR_CODE, but got " + format);
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("Requested dimensions are too small: " + width + 'x' + height);
        }
        ErrorCorrectionLevel errorCorrectionLevel = ErrorCorrectionLevel.L;
        int quietZone = 4;
        if (hints != null) {
            if (hints.containsKey(EncodeHintType.ERROR_CORRECTION)) {
                errorCorrectionLevel = ErrorCorrectionLevel.valueOf((String)hints.get(EncodeHintType.ERROR_CORRECTION).toString());
            }
            if (hints.containsKey(EncodeHintType.MARGIN)) {
                quietZone = Integer.parseInt(hints.get(EncodeHintType.MARGIN).toString());
            }
        }
        QRCode code = Encoder.encode((String)contents, (ErrorCorrectionLevel)errorCorrectionLevel, hints);
        return this.renderResult(code, width, height, quietZone);
    }

    @Override
    public BitMatrixInfo renderResult(QRCode code, int width, int height, int quietZone) {
        ByteMatrix input = code.getMatrix();
        if (input == null) {
            throw new IllegalStateException();
        }
        int inputWidth = input.getWidth();
        int inputHeight = input.getHeight();
        int qrWidth = inputWidth + quietZone * 2;
        int qrHeight = inputHeight + quietZone * 2;
        int outputWidth = Math.max(width, qrWidth);
        int outputHeight = Math.max(height, qrHeight);
        int multiple = Math.min(outputWidth / qrWidth, outputHeight / qrHeight);
        int leftPadding = (outputWidth - inputWidth * multiple) / 2;
        int topPadding = (outputHeight - inputHeight * multiple) / 2;
        BitMatrixInfo bitMatrixInfo = this.buildOutputMatrixInfo(code, outputWidth, outputHeight, multiple, topPadding, leftPadding);
        return bitMatrixInfo;
    }

    protected BitMatrixInfo buildOutputMatrixInfo(QRCode qrCode, int outputWidth, int outputHeight, int multiple, int topPadding, int leftPadding) {
        return BitMatrixInfo.builder().multiple(multiple).outputWidth(outputWidth).outputHeight(outputHeight).topPadding(topPadding).leftPadding(leftPadding).qrCode(qrCode).build();
    }
}

