/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.qrcode.core.util;

import cn.patterncat.qrcode.core.bean.BitMatrixInfo;
import cn.patterncat.qrcode.core.bean.DetectInfo;
import cn.patterncat.qrcode.core.bean.DetectPositionType;
import cn.patterncat.qrcode.core.bean.InOutType;
import cn.patterncat.qrcode.core.bean.QrCodeConfig;
import cn.patterncat.qrcode.core.color.GradientColor;
import cn.patterncat.qrcode.core.util.ColorUtil;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Optional;

public class QrCodeUtil {
    public static final int OUT_DETECT_RECT_SIZE = 7;

    public static BufferedImage addBgImgAndUseBgImgAsQrCodeOnColor(BufferedImage bgImg, BufferedImage qrCode, QrCodeConfig config) {
        int width = qrCode.getWidth();
        int height = qrCode.getHeight();
        Graphics2D g2 = bgImg.createGraphics();
        g2.setComposite(AlphaComposite.getInstance(10, config.getBgImgOpacity()));
        int onColor = config.getOnColorIntValue();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int pointColor = qrCode.getRGB(x, y);
                if (pointColor != onColor) continue;
                qrCode.setRGB(x, y, bgImg.getRGB(x, y));
            }
        }
        g2.drawImage(qrCode, 0, 0, width, height, null);
        g2.dispose();
        bgImg.flush();
        return bgImg;
    }

    public static BufferedImage toColorBufferedImage(BitMatrixInfo bitMatrixInfo, QrCodeConfig config, int colorModel) {
        int offColor = config.getOffColorIntValue();
        int onColor = config.getOnColorIntValue();
        int gradientOnColor = config.getGradientOnColorIntValue();
        int detectInColor = config.getDetectInColorIntValue();
        int detectOutColor = config.getDetectOutColorIntValue();
        int width = bitMatrixInfo.getOutputWidth();
        int height = bitMatrixInfo.getOutputHeight();
        BufferedImage image = new BufferedImage(width, height, colorModel);
        Graphics2D g2 = image.createGraphics();
        g2.setColor(new Color(offColor));
        g2.fillRect(0, 0, width, height);
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ByteMatrix byteMatrix = bitMatrixInfo.getQrCode().getMatrix();
        int multiple = bitMatrixInfo.getMultiple();
        int byteWidth = byteMatrix.getWidth();
        int byteHeight = byteMatrix.getHeight();
        int leftPadding = bitMatrixInfo.getLeftPadding();
        int topPadding = bitMatrixInfo.getTopPadding();
        GradientColor gradient = null;
        Color targetOnColor = new Color(onColor);
        if (gradientOnColor != onColor) {
            gradient = new GradientColor(byteWidth, byteHeight, colorModel, config.getGradientType(), new Color(onColor), new Color(gradientOnColor));
        }
        for (int x = 0; x < byteWidth; ++x) {
            for (int y = 0; y < byteHeight; ++y) {
                int outputX = leftPadding + x * multiple;
                int outputY = topPadding + y * multiple;
                if (byteMatrix.get(x, y) == 0) {
                    g2.setColor(new Color(offColor));
                    g2.fillRect(outputX, outputY, multiple, multiple);
                    continue;
                }
                Optional<DetectInfo> optional = QrCodeUtil.isDectectPosition(byteMatrix, x, y);
                if (optional.isPresent()) {
                    if (InOutType.OUTER == optional.get().getInOutType()) {
                        g2.setColor(new Color(detectOutColor));
                    } else {
                        g2.setColor(new Color(detectInColor));
                    }
                    g2.fillRect(outputX, outputY, multiple, multiple);
                    continue;
                }
                if (gradient != null) {
                    targetOnColor = new Color(gradient.getRGB(x, y));
                }
                g2.setColor(targetOnColor);
                config.getDataShape().draw(g2, outputX, outputY, multiple, multiple);
            }
        }
        g2.dispose();
        image.flush();
        return image;
    }

    public static int getBufferedImageColorModel(int onColor, int offColor, boolean useBinaryIfMatch) {
        if (onColor == -16777216 && offColor == -1) {
            if (!useBinaryIfMatch) {
                return 1;
            }
            return 12;
        }
        if (ColorUtil.hasTransparency(onColor) || ColorUtil.hasTransparency(offColor)) {
            return 2;
        }
        return 1;
    }

    public static Optional<DetectInfo> isDectectPosition(ByteMatrix byteMatrix, int x, int y) {
        int width = byteMatrix.getWidth();
        int height = byteMatrix.getHeight();
        if (x < 7 && y < 7) {
            DetectInfo.DetectInfoBuilder builder = DetectInfo.builder().positionType(DetectPositionType.LEFT_TOP);
            if (x == 0 || y == 0 || x == 6 || y == 6) {
                builder.inOutType(InOutType.OUTER);
            } else {
                builder.inOutType(InOutType.INNER);
            }
            return Optional.of(builder.build());
        }
        if (x < 7 && y >= height - 7) {
            DetectInfo.DetectInfoBuilder builder = DetectInfo.builder().positionType(DetectPositionType.LEFT_BOTTOM);
            if (x == 0 || y == height - 7 || x == 6 || y == height - 1) {
                builder.inOutType(InOutType.OUTER);
            } else {
                builder.inOutType(InOutType.INNER);
            }
            return Optional.of(builder.build());
        }
        if (x >= width - 7 && y < 7) {
            DetectInfo.DetectInfoBuilder builder = DetectInfo.builder().positionType(DetectPositionType.RIGHT_TOP);
            if (x == width - 7 || y == 0 || x == width - 1 || y == 6) {
                builder.inOutType(InOutType.OUTER);
            } else {
                builder.inOutType(InOutType.INNER);
            }
            return Optional.of(builder.build());
        }
        return Optional.empty();
    }
}

