/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.qrcode.core.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class ImgUtil {
    public static void coverImage(BufferedImage srcImg, BufferedImage dstImg, int widthRatio, int heightRatio, Composite composite) throws IOException {
        int dstImgWidth = dstImg.getWidth();
        int dstImgHeight = dstImg.getHeight();
        int w = dstImgWidth / widthRatio;
        int h = dstImgHeight / heightRatio;
        int x = (dstImgWidth - w) / 2;
        int y = (dstImgHeight - h) / 2;
        Graphics2D g2 = dstImg.createGraphics();
        g2.setComposite(composite);
        g2.drawImage(srcImg, x, y, w, h, null);
        g2.dispose();
        dstImg.flush();
    }

    public static BufferedImage addRoundedBorder(BufferedImage image, int radius, int borderSize, Color borderColor) {
        int w = image.getWidth() + borderSize * 2;
        int h = image.getHeight() + borderSize * 2;
        BufferedImage output = new BufferedImage(w, h, 2);
        Graphics2D g2 = output.createGraphics();
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(borderColor == null ? Color.WHITE : borderColor);
        g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, w, h, radius, radius));
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.drawImage((Image)image, borderSize, borderSize, null);
        g2.dispose();
        return output;
    }

    public static BufferedImage roundImageCorner(BufferedImage image, int radius) {
        int w = image.getWidth();
        int h = image.getHeight();
        BufferedImage output = new BufferedImage(w, h, 2);
        Graphics2D g2 = output.createGraphics();
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.WHITE);
        g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, w, h, radius, radius));
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.drawImage((Image)image, 0, 0, null);
        g2.dispose();
        return output;
    }

    public static BufferedImage fromPathOrUrl(String location) throws IOException {
        if (location.startsWith("http")) {
            return ImageIO.read(new URL(location));
        }
        return ImageIO.read(new File(location));
    }
}

