/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.qrcode.core.util;

import java.awt.Color;

public class ColorUtil {
    public static int argbString2Int(String argb) {
        return Long.decode(argb).intValue();
    }

    public static Color argb2Color(String argb) {
        int color = ColorUtil.argbString2Int(argb);
        int a = (0x7F000000 & color) >> 24 | 0x80;
        int r = (0xFF0000 & color) >> 16;
        int g = (0xFF00 & color) >> 8;
        int b = 0xFF & color;
        return new Color(r, g, b, a);
    }

    public static boolean hasTransparency(int argb) {
        return (argb & 0xFF000000) != -16777216;
    }

    public static String opacity2AlphaHex(float opacity) {
        if (opacity > 1.0f || opacity < 0.0f) {
            throw new IllegalArgumentException("opacity should in [0,1]");
        }
        int alpha = Math.round(opacity * 255.0f);
        String hex = Integer.toHexString(alpha).toUpperCase();
        if (hex.length() == 1) {
            hex = "0" + hex;
        }
        return hex;
    }

    public static Color argb(Color color, float opacity) {
        if (opacity > 1.0f || opacity < 0.0f) {
            throw new IllegalArgumentException("opacity should in [0,1]");
        }
        int alpha = Math.round(opacity * 255.0f);
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static String argbHex(Color color, float opacity) {
        Color argb = ColorUtil.argb(color, opacity);
        return "0x" + Integer.toHexString(argb.getRGB()).toUpperCase();
    }
}

