/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.qrcode.core.coder;

import cn.patterncat.qrcode.core.bean.BitMatrixInfo;
import cn.patterncat.qrcode.core.bean.ImageType;
import cn.patterncat.qrcode.core.bean.QrCodeConfig;
import cn.patterncat.qrcode.core.coder.QrCodeEnDeCoder;
import cn.patterncat.qrcode.core.util.ColorUtil;
import cn.patterncat.qrcode.core.util.ImgUtil;
import cn.patterncat.qrcode.core.util.QrCodeUtil;
import cn.patterncat.qrcode.core.writer.DefaultQrCodeWriterQrCode;
import cn.patterncat.qrcode.core.writer.QrCodeMatrixWriter;
import cn.patterncat.qrcode.core.writer.StrictQuietZoneWriterQrCode;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.LuminanceSource;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.QRCodeReader;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public abstract class AbstractEnDeCoder
implements QrCodeEnDeCoder {
    public static final Map<DecodeHintType, Object> DECODE_HINTS = new HashMap<DecodeHintType, Object>(){
        {
            this.put(DecodeHintType.CHARACTER_SET, StandardCharsets.UTF_8.name());
        }
    };
    QrCodeMatrixWriter defaultWriter = new DefaultQrCodeWriterQrCode();
    QrCodeMatrixWriter strictQuietZoneWriter = new StrictQuietZoneWriterQrCode();

    @Override
    public BufferedImage encodeAsBufferedImage(QrCodeConfig config) throws WriterException, IOException {
        BitMatrixInfo bitMatrixInfo = this.encodeMsgToMatrix(config);
        return this.decorate(config, bitMatrixInfo);
    }

    @Override
    public String decode(BufferedImage image) throws FormatException, ChecksumException, NotFoundException {
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        QRCodeReader qrCodeReader = new QRCodeReader();
        Result result = qrCodeReader.decode(bitmap, DECODE_HINTS);
        return result.getText();
    }

    @Override
    public void write(QrCodeConfig config, OutputStream outputStream) throws IOException, WriterException {
        BufferedImage bufferedImage = this.encodeAsBufferedImage(config);
        if (!ImageIO.write((RenderedImage)bufferedImage, config.getImageType().name(), outputStream)) {
            throw new IOException("Could not write an image of format " + config.getImageType().name());
        }
    }

    protected BitMatrixInfo encodeMsgToMatrix(QrCodeConfig config) throws WriterException {
        if (config.isPaddingStrict()) {
            return this.strictQuietZoneWriter.encode(config.getMsg(), BarcodeFormat.QR_CODE, config.getSize(), config.getSize(), config.buildEncodeHints());
        }
        return this.defaultWriter.encode(config.getMsg(), BarcodeFormat.QR_CODE, config.getSize(), config.getSize(), config.buildEncodeHints());
    }

    protected BufferedImage decorate(QrCodeConfig config, BitMatrixInfo bitMatrixInfo) throws IOException {
        int qrCodeWidth = bitMatrixInfo.getOutputWidth();
        int qrCodeHeight = bitMatrixInfo.getOutputHeight();
        BufferedImage qrCodeImg = this.drawQrCode(bitMatrixInfo, config);
        int neededWidth = config.getSize();
        int neededHeight = config.getSize();
        if (qrCodeWidth != neededWidth || qrCodeHeight != neededHeight) {
            BufferedImage tmp = new BufferedImage(neededWidth, neededHeight, qrCodeImg.getType());
            tmp.getGraphics().drawImage(qrCodeImg.getScaledInstance(neededWidth, neededHeight, 4), 0, 0, null);
            qrCodeImg = tmp;
        }
        if (config.hasBgImage()) {
            qrCodeImg = this.coverQrCodeToBgImage(qrCodeImg, config);
        }
        if (config.hasLogo()) {
            this.drawLogoOnQrCode(qrCodeImg, config);
        }
        return qrCodeImg;
    }

    protected BufferedImage drawQrCode(BitMatrixInfo bitMatrixInfo, QrCodeConfig config) {
        int colorModel = config.getImageType() == ImageType.jpg ? 1 : 2;
        return QrCodeUtil.toColorBufferedImage(bitMatrixInfo, config, colorModel);
    }

    protected void drawLogoOnQrCode(BufferedImage qrCode, QrCodeConfig config) throws IOException {
        BufferedImage logoImg = ImgUtil.fromPathOrUrl(config.getLogo());
        int roundRadius = this.calLogoRadius(logoImg, config);
        if (config.isLogoRoundCorner()) {
            logoImg = ImgUtil.roundImageCorner(logoImg, roundRadius);
        }
        if (config.isLogoBorder()) {
            Color logoBorderColor = ColorUtil.argb2Color(config.getLogoBorderColor());
            int borderSize = this.calLogoBorderSize(logoImg, config);
            logoImg = ImgUtil.addRoundedBorder(logoImg, roundRadius, borderSize, logoBorderColor);
        }
        ImgUtil.coverImage(logoImg, qrCode, config.getLogoSizeRatio(), config.getLogoSizeRatio(), AlphaComposite.SrcAtop);
    }

    protected BufferedImage coverQrCodeToBgImage(BufferedImage qrCode, QrCodeConfig config) throws IOException {
        BufferedImage bgImage = ImgUtil.fromPathOrUrl(config.getBgImage());
        int width = qrCode.getWidth();
        int height = qrCode.getHeight();
        BufferedImage dstImg = bgImage;
        if (bgImage.getWidth() != width || height != qrCode.getHeight()) {
            dstImg = new BufferedImage(width, height, 2);
            dstImg.getGraphics().drawImage(bgImage.getScaledInstance(width, height, 4), 0, 0, null);
        }
        if (config.isUseBgImgColor()) {
            return QrCodeUtil.addBgImgAndUseBgImgAsQrCodeOnColor(dstImg, qrCode, config);
        }
        ImgUtil.coverImage(qrCode, dstImg, 1, 1, AlphaComposite.getInstance(10, config.getBgImgOpacity()));
        return dstImg;
    }

    protected int calLogoBorderSize(BufferedImage logoImg, QrCodeConfig config) {
        return logoImg.getWidth() / config.getLogoBroderSizeRatio();
    }

    protected int calLogoRadius(BufferedImage logoImg, QrCodeConfig config) {
        if (!config.isLogoRoundCorner()) {
            return 0;
        }
        if (0 == config.getLogoRadius()) {
            return logoImg.getWidth() >> 2;
        }
        return config.getLogoRadius();
    }
}

