/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.qrcode.core.bean;

import cn.patterncat.qrcode.core.bean.ImageType;
import cn.patterncat.qrcode.core.bean.QrCodeDataShape;
import cn.patterncat.qrcode.core.color.GradientType;
import cn.patterncat.qrcode.core.util.ColorUtil;
import cn.patterncat.qrcode.core.util.ValidationUtil;
import com.google.zxing.EncodeHintType;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class QrCodeConfig {
    public static final int DEFAULT_IMG_SIZE = 200;
    public static final int DEFAULT_IMG_PADDING = 1;
    public static final String BLACK = "0xFF000000";
    public static final String WHITE = "0xFFFFFFFF";
    public static final int RECT_RADIUS = 0;
    public static final int ROUND_RADIUS = 180;
    private String msg;
    private String charset;
    private int size;
    private int padding;
    private boolean paddingStrict;
    private String offColor;
    private String onColor;
    private String gradientOnColor;
    private GradientType gradientType;
    private String bgImage;
    private float bgImgOpacity;
    private String detectOutColor;
    private String detectInColor;
    private boolean useBgImgColor;
    private ImageType imageType;
    private QrCodeDataShape dataShape;
    private ErrorCorrectionLevel errorCorrectionLevel;
    private String logo;
    private int logoSizeRatio;
    private boolean logoRoundCorner;
    private int logoRadius;
    private boolean logoBorder;
    private int logoBroderSizeRatio;
    private String logoBorderColor;

    public boolean hasLogo() {
        return StringUtils.isNotBlank((CharSequence)this.logo);
    }

    public boolean hasBgImage() {
        return StringUtils.isNotBlank((CharSequence)this.bgImage);
    }

    public void validateParams() {
        ValidationUtil.checkNotBlank(this.msg, "msg should not be empty");
        ValidationUtil.checkExpressionTrue(this.size > 0, "size should > 0");
        ValidationUtil.checkExpressionTrue(this.padding >= 0 && this.padding < this.size, "padding should >= 0 and < size");
        ValidationUtil.checkExpressionTrue(this.logoSizeRatio > 0, "logoSizeRatio should > 0");
        ValidationUtil.checkExpressionTrue(this.logoBroderSizeRatio > 0, "logoBroderSizeRatio should > 0");
        ValidationUtil.checkExpressionTrue(this.logoRadius > -1, "logoRadius should > -1");
        ValidationUtil.checkExpressionTrue(this.imageType != null, "imageType should not be null");
        ValidationUtil.checkExpressionTrue(this.errorCorrectionLevel != null, "errorCorrectionLevel should not be null");
        ValidationUtil.checkExpressionTrue(this.dataShape != null, "dataShape should not be null");
        ValidationUtil.checkExpressionTrue(this.bgImgOpacity >= 0.0f && this.bgImgOpacity <= 1.0f, "bgImgOpacity should >=0 and <= 1");
        try {
            this.getOffColorIntValue();
            this.getOnColorIntValue();
            this.getGradientOnColorIntValue();
            this.getDetectInColor();
            this.getDetectOutColor();
            this.getLogoBorderColorIntValue();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("illegal color string", e);
        }
    }

    public Map<EncodeHintType, Object> buildEncodeHints() {
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>(3);
        hints.put(EncodeHintType.ERROR_CORRECTION, this.getErrorCorrectionLevel());
        hints.put(EncodeHintType.CHARACTER_SET, this.getCharset());
        hints.put(EncodeHintType.MARGIN, this.getPadding());
        return hints;
    }

    public int getOffColorIntValue() {
        return ColorUtil.argbString2Int(this.offColor);
    }

    public int getOnColorIntValue() {
        return ColorUtil.argbString2Int(this.onColor);
    }

    public int getGradientOnColorIntValue() {
        return ColorUtil.argbString2Int(this.gradientOnColor);
    }

    public int getDetectOutColorIntValue() {
        return ColorUtil.argbString2Int(this.detectOutColor);
    }

    public int getDetectInColorIntValue() {
        return ColorUtil.argbString2Int(this.detectInColor);
    }

    public int getLogoBorderColorIntValue() {
        return ColorUtil.argbString2Int(this.logoBorderColor);
    }

    public static QrCodeConfigBuilder builder() {
        return new InternalBuilder();
    }

    private static String $default$charset() {
        return StandardCharsets.UTF_8.name();
    }

    private static int $default$size() {
        return 200;
    }

    private static int $default$padding() {
        return 1;
    }

    private static boolean $default$paddingStrict() {
        return false;
    }

    private static String $default$offColor() {
        return WHITE;
    }

    private static String $default$onColor() {
        return BLACK;
    }

    private static String $default$gradientOnColor() {
        return BLACK;
    }

    private static GradientType $default$gradientType() {
        return GradientType.LEFT_TOP_RIGHT_DOWN;
    }

    private static float $default$bgImgOpacity() {
        return 0.8f;
    }

    private static String $default$detectOutColor() {
        return BLACK;
    }

    private static String $default$detectInColor() {
        return BLACK;
    }

    private static boolean $default$useBgImgColor() {
        return false;
    }

    private static ImageType $default$imageType() {
        return ImageType.png;
    }

    private static QrCodeDataShape $default$dataShape() {
        return QrCodeDataShape.RECT;
    }

    private static ErrorCorrectionLevel $default$errorCorrectionLevel() {
        return ErrorCorrectionLevel.H;
    }

    private static int $default$logoSizeRatio() {
        return 4;
    }

    private static boolean $default$logoRoundCorner() {
        return false;
    }

    private static int $default$logoRadius() {
        return 0;
    }

    private static boolean $default$logoBorder() {
        return true;
    }

    private static int $default$logoBroderSizeRatio() {
        return 15;
    }

    private static String $default$logoBorderColor() {
        return WHITE;
    }

    @ConstructorProperties(value={"msg", "charset", "size", "padding", "paddingStrict", "offColor", "onColor", "gradientOnColor", "gradientType", "bgImage", "bgImgOpacity", "detectOutColor", "detectInColor", "useBgImgColor", "imageType", "dataShape", "errorCorrectionLevel", "logo", "logoSizeRatio", "logoRoundCorner", "logoRadius", "logoBorder", "logoBroderSizeRatio", "logoBorderColor"})
    QrCodeConfig(String msg, String charset, int size, int padding, boolean paddingStrict, String offColor, String onColor, String gradientOnColor, GradientType gradientType, String bgImage, float bgImgOpacity, String detectOutColor, String detectInColor, boolean useBgImgColor, ImageType imageType, QrCodeDataShape dataShape, ErrorCorrectionLevel errorCorrectionLevel, String logo, int logoSizeRatio, boolean logoRoundCorner, int logoRadius, boolean logoBorder, int logoBroderSizeRatio, String logoBorderColor) {
        this.msg = msg;
        this.charset = charset;
        this.size = size;
        this.padding = padding;
        this.paddingStrict = paddingStrict;
        this.offColor = offColor;
        this.onColor = onColor;
        this.gradientOnColor = gradientOnColor;
        this.gradientType = gradientType;
        this.bgImage = bgImage;
        this.bgImgOpacity = bgImgOpacity;
        this.detectOutColor = detectOutColor;
        this.detectInColor = detectInColor;
        this.useBgImgColor = useBgImgColor;
        this.imageType = imageType;
        this.dataShape = dataShape;
        this.errorCorrectionLevel = errorCorrectionLevel;
        this.logo = logo;
        this.logoSizeRatio = logoSizeRatio;
        this.logoRoundCorner = logoRoundCorner;
        this.logoRadius = logoRadius;
        this.logoBorder = logoBorder;
        this.logoBroderSizeRatio = logoBroderSizeRatio;
        this.logoBorderColor = logoBorderColor;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getCharset() {
        return this.charset;
    }

    public int getSize() {
        return this.size;
    }

    public int getPadding() {
        return this.padding;
    }

    public boolean isPaddingStrict() {
        return this.paddingStrict;
    }

    public String getOffColor() {
        return this.offColor;
    }

    public String getOnColor() {
        return this.onColor;
    }

    public String getGradientOnColor() {
        return this.gradientOnColor;
    }

    public GradientType getGradientType() {
        return this.gradientType;
    }

    public String getBgImage() {
        return this.bgImage;
    }

    public float getBgImgOpacity() {
        return this.bgImgOpacity;
    }

    public String getDetectOutColor() {
        return this.detectOutColor;
    }

    public String getDetectInColor() {
        return this.detectInColor;
    }

    public boolean isUseBgImgColor() {
        return this.useBgImgColor;
    }

    public ImageType getImageType() {
        return this.imageType;
    }

    public QrCodeDataShape getDataShape() {
        return this.dataShape;
    }

    public ErrorCorrectionLevel getErrorCorrectionLevel() {
        return this.errorCorrectionLevel;
    }

    public String getLogo() {
        return this.logo;
    }

    public int getLogoSizeRatio() {
        return this.logoSizeRatio;
    }

    public boolean isLogoRoundCorner() {
        return this.logoRoundCorner;
    }

    public int getLogoRadius() {
        return this.logoRadius;
    }

    public boolean isLogoBorder() {
        return this.logoBorder;
    }

    public int getLogoBroderSizeRatio() {
        return this.logoBroderSizeRatio;
    }

    public String getLogoBorderColor() {
        return this.logoBorderColor;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public void setPaddingStrict(boolean paddingStrict) {
        this.paddingStrict = paddingStrict;
    }

    public void setOffColor(String offColor) {
        this.offColor = offColor;
    }

    public void setOnColor(String onColor) {
        this.onColor = onColor;
    }

    public void setGradientOnColor(String gradientOnColor) {
        this.gradientOnColor = gradientOnColor;
    }

    public void setGradientType(GradientType gradientType) {
        this.gradientType = gradientType;
    }

    public void setBgImage(String bgImage) {
        this.bgImage = bgImage;
    }

    public void setBgImgOpacity(float bgImgOpacity) {
        this.bgImgOpacity = bgImgOpacity;
    }

    public void setDetectOutColor(String detectOutColor) {
        this.detectOutColor = detectOutColor;
    }

    public void setDetectInColor(String detectInColor) {
        this.detectInColor = detectInColor;
    }

    public void setUseBgImgColor(boolean useBgImgColor) {
        this.useBgImgColor = useBgImgColor;
    }

    public void setImageType(ImageType imageType) {
        this.imageType = imageType;
    }

    public void setDataShape(QrCodeDataShape dataShape) {
        this.dataShape = dataShape;
    }

    public void setErrorCorrectionLevel(ErrorCorrectionLevel errorCorrectionLevel) {
        this.errorCorrectionLevel = errorCorrectionLevel;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public void setLogoSizeRatio(int logoSizeRatio) {
        this.logoSizeRatio = logoSizeRatio;
    }

    public void setLogoRoundCorner(boolean logoRoundCorner) {
        this.logoRoundCorner = logoRoundCorner;
    }

    public void setLogoRadius(int logoRadius) {
        this.logoRadius = logoRadius;
    }

    public void setLogoBorder(boolean logoBorder) {
        this.logoBorder = logoBorder;
    }

    public void setLogoBroderSizeRatio(int logoBroderSizeRatio) {
        this.logoBroderSizeRatio = logoBroderSizeRatio;
    }

    public void setLogoBorderColor(String logoBorderColor) {
        this.logoBorderColor = logoBorderColor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QrCodeConfig)) {
            return false;
        }
        QrCodeConfig other = (QrCodeConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        String this$charset = this.getCharset();
        String other$charset = other.getCharset();
        if (this$charset == null ? other$charset != null : !this$charset.equals(other$charset)) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getPadding() != other.getPadding()) {
            return false;
        }
        if (this.isPaddingStrict() != other.isPaddingStrict()) {
            return false;
        }
        String this$offColor = this.getOffColor();
        String other$offColor = other.getOffColor();
        if (this$offColor == null ? other$offColor != null : !this$offColor.equals(other$offColor)) {
            return false;
        }
        String this$onColor = this.getOnColor();
        String other$onColor = other.getOnColor();
        if (this$onColor == null ? other$onColor != null : !this$onColor.equals(other$onColor)) {
            return false;
        }
        String this$gradientOnColor = this.getGradientOnColor();
        String other$gradientOnColor = other.getGradientOnColor();
        if (this$gradientOnColor == null ? other$gradientOnColor != null : !this$gradientOnColor.equals(other$gradientOnColor)) {
            return false;
        }
        GradientType this$gradientType = this.getGradientType();
        GradientType other$gradientType = other.getGradientType();
        if (this$gradientType == null ? other$gradientType != null : !((Object)((Object)this$gradientType)).equals((Object)other$gradientType)) {
            return false;
        }
        String this$bgImage = this.getBgImage();
        String other$bgImage = other.getBgImage();
        if (this$bgImage == null ? other$bgImage != null : !this$bgImage.equals(other$bgImage)) {
            return false;
        }
        if (Float.compare(this.getBgImgOpacity(), other.getBgImgOpacity()) != 0) {
            return false;
        }
        String this$detectOutColor = this.getDetectOutColor();
        String other$detectOutColor = other.getDetectOutColor();
        if (this$detectOutColor == null ? other$detectOutColor != null : !this$detectOutColor.equals(other$detectOutColor)) {
            return false;
        }
        String this$detectInColor = this.getDetectInColor();
        String other$detectInColor = other.getDetectInColor();
        if (this$detectInColor == null ? other$detectInColor != null : !this$detectInColor.equals(other$detectInColor)) {
            return false;
        }
        if (this.isUseBgImgColor() != other.isUseBgImgColor()) {
            return false;
        }
        ImageType this$imageType = this.getImageType();
        ImageType other$imageType = other.getImageType();
        if (this$imageType == null ? other$imageType != null : !((Object)((Object)this$imageType)).equals((Object)other$imageType)) {
            return false;
        }
        QrCodeDataShape this$dataShape = this.getDataShape();
        QrCodeDataShape other$dataShape = other.getDataShape();
        if (this$dataShape == null ? other$dataShape != null : !((Object)((Object)this$dataShape)).equals((Object)other$dataShape)) {
            return false;
        }
        ErrorCorrectionLevel this$errorCorrectionLevel = this.getErrorCorrectionLevel();
        ErrorCorrectionLevel other$errorCorrectionLevel = other.getErrorCorrectionLevel();
        if (this$errorCorrectionLevel == null ? other$errorCorrectionLevel != null : !this$errorCorrectionLevel.equals(other$errorCorrectionLevel)) {
            return false;
        }
        String this$logo = this.getLogo();
        String other$logo = other.getLogo();
        if (this$logo == null ? other$logo != null : !this$logo.equals(other$logo)) {
            return false;
        }
        if (this.getLogoSizeRatio() != other.getLogoSizeRatio()) {
            return false;
        }
        if (this.isLogoRoundCorner() != other.isLogoRoundCorner()) {
            return false;
        }
        if (this.getLogoRadius() != other.getLogoRadius()) {
            return false;
        }
        if (this.isLogoBorder() != other.isLogoBorder()) {
            return false;
        }
        if (this.getLogoBroderSizeRatio() != other.getLogoBroderSizeRatio()) {
            return false;
        }
        String this$logoBorderColor = this.getLogoBorderColor();
        String other$logoBorderColor = other.getLogoBorderColor();
        return !(this$logoBorderColor == null ? other$logoBorderColor != null : !this$logoBorderColor.equals(other$logoBorderColor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QrCodeConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        String $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
        result = result * 59 + this.getSize();
        result = result * 59 + this.getPadding();
        result = result * 59 + (this.isPaddingStrict() ? 79 : 97);
        String $offColor = this.getOffColor();
        result = result * 59 + ($offColor == null ? 43 : $offColor.hashCode());
        String $onColor = this.getOnColor();
        result = result * 59 + ($onColor == null ? 43 : $onColor.hashCode());
        String $gradientOnColor = this.getGradientOnColor();
        result = result * 59 + ($gradientOnColor == null ? 43 : $gradientOnColor.hashCode());
        GradientType $gradientType = this.getGradientType();
        result = result * 59 + ($gradientType == null ? 43 : ((Object)((Object)$gradientType)).hashCode());
        String $bgImage = this.getBgImage();
        result = result * 59 + ($bgImage == null ? 43 : $bgImage.hashCode());
        result = result * 59 + Float.floatToIntBits(this.getBgImgOpacity());
        String $detectOutColor = this.getDetectOutColor();
        result = result * 59 + ($detectOutColor == null ? 43 : $detectOutColor.hashCode());
        String $detectInColor = this.getDetectInColor();
        result = result * 59 + ($detectInColor == null ? 43 : $detectInColor.hashCode());
        result = result * 59 + (this.isUseBgImgColor() ? 79 : 97);
        ImageType $imageType = this.getImageType();
        result = result * 59 + ($imageType == null ? 43 : ((Object)((Object)$imageType)).hashCode());
        QrCodeDataShape $dataShape = this.getDataShape();
        result = result * 59 + ($dataShape == null ? 43 : ((Object)((Object)$dataShape)).hashCode());
        ErrorCorrectionLevel $errorCorrectionLevel = this.getErrorCorrectionLevel();
        result = result * 59 + ($errorCorrectionLevel == null ? 43 : $errorCorrectionLevel.hashCode());
        String $logo = this.getLogo();
        result = result * 59 + ($logo == null ? 43 : $logo.hashCode());
        result = result * 59 + this.getLogoSizeRatio();
        result = result * 59 + (this.isLogoRoundCorner() ? 79 : 97);
        result = result * 59 + this.getLogoRadius();
        result = result * 59 + (this.isLogoBorder() ? 79 : 97);
        result = result * 59 + this.getLogoBroderSizeRatio();
        String $logoBorderColor = this.getLogoBorderColor();
        result = result * 59 + ($logoBorderColor == null ? 43 : $logoBorderColor.hashCode());
        return result;
    }

    public String toString() {
        return "QrCodeConfig(msg=" + this.getMsg() + ", charset=" + this.getCharset() + ", size=" + this.getSize() + ", padding=" + this.getPadding() + ", paddingStrict=" + this.isPaddingStrict() + ", offColor=" + this.getOffColor() + ", onColor=" + this.getOnColor() + ", gradientOnColor=" + this.getGradientOnColor() + ", gradientType=" + (Object)((Object)this.getGradientType()) + ", bgImage=" + this.getBgImage() + ", bgImgOpacity=" + this.getBgImgOpacity() + ", detectOutColor=" + this.getDetectOutColor() + ", detectInColor=" + this.getDetectInColor() + ", useBgImgColor=" + this.isUseBgImgColor() + ", imageType=" + (Object)((Object)this.getImageType()) + ", dataShape=" + (Object)((Object)this.getDataShape()) + ", errorCorrectionLevel=" + this.getErrorCorrectionLevel() + ", logo=" + this.getLogo() + ", logoSizeRatio=" + this.getLogoSizeRatio() + ", logoRoundCorner=" + this.isLogoRoundCorner() + ", logoRadius=" + this.getLogoRadius() + ", logoBorder=" + this.isLogoBorder() + ", logoBroderSizeRatio=" + this.getLogoBroderSizeRatio() + ", logoBorderColor=" + this.getLogoBorderColor() + ")";
    }

    public static class QrCodeConfigBuilder {
        private String msg;
        private boolean charset$set;
        private String charset;
        private boolean size$set;
        private int size;
        private boolean padding$set;
        private int padding;
        private boolean paddingStrict$set;
        private boolean paddingStrict;
        private boolean offColor$set;
        private String offColor;
        private boolean onColor$set;
        private String onColor;
        private boolean gradientOnColor$set;
        private String gradientOnColor;
        private boolean gradientType$set;
        private GradientType gradientType;
        private String bgImage;
        private boolean bgImgOpacity$set;
        private float bgImgOpacity;
        private boolean detectOutColor$set;
        private String detectOutColor;
        private boolean detectInColor$set;
        private String detectInColor;
        private boolean useBgImgColor$set;
        private boolean useBgImgColor;
        private boolean imageType$set;
        private ImageType imageType;
        private boolean dataShape$set;
        private QrCodeDataShape dataShape;
        private boolean errorCorrectionLevel$set;
        private ErrorCorrectionLevel errorCorrectionLevel;
        private String logo;
        private boolean logoSizeRatio$set;
        private int logoSizeRatio;
        private boolean logoRoundCorner$set;
        private boolean logoRoundCorner;
        private boolean logoRadius$set;
        private int logoRadius;
        private boolean logoBorder$set;
        private boolean logoBorder;
        private boolean logoBroderSizeRatio$set;
        private int logoBroderSizeRatio;
        private boolean logoBorderColor$set;
        private String logoBorderColor;

        QrCodeConfigBuilder() {
        }

        public QrCodeConfigBuilder msg(String msg) {
            this.msg = msg;
            return this;
        }

        public QrCodeConfigBuilder charset(String charset) {
            this.charset = charset;
            this.charset$set = true;
            return this;
        }

        public QrCodeConfigBuilder size(int size) {
            this.size = size;
            this.size$set = true;
            return this;
        }

        public QrCodeConfigBuilder padding(int padding) {
            this.padding = padding;
            this.padding$set = true;
            return this;
        }

        public QrCodeConfigBuilder paddingStrict(boolean paddingStrict) {
            this.paddingStrict = paddingStrict;
            this.paddingStrict$set = true;
            return this;
        }

        public QrCodeConfigBuilder offColor(String offColor) {
            this.offColor = offColor;
            this.offColor$set = true;
            return this;
        }

        public QrCodeConfigBuilder onColor(String onColor) {
            this.onColor = onColor;
            this.onColor$set = true;
            return this;
        }

        public QrCodeConfigBuilder gradientOnColor(String gradientOnColor) {
            this.gradientOnColor = gradientOnColor;
            this.gradientOnColor$set = true;
            return this;
        }

        public QrCodeConfigBuilder gradientType(GradientType gradientType) {
            this.gradientType = gradientType;
            this.gradientType$set = true;
            return this;
        }

        public QrCodeConfigBuilder bgImage(String bgImage) {
            this.bgImage = bgImage;
            return this;
        }

        public QrCodeConfigBuilder bgImgOpacity(float bgImgOpacity) {
            this.bgImgOpacity = bgImgOpacity;
            this.bgImgOpacity$set = true;
            return this;
        }

        public QrCodeConfigBuilder detectOutColor(String detectOutColor) {
            this.detectOutColor = detectOutColor;
            this.detectOutColor$set = true;
            return this;
        }

        public QrCodeConfigBuilder detectInColor(String detectInColor) {
            this.detectInColor = detectInColor;
            this.detectInColor$set = true;
            return this;
        }

        public QrCodeConfigBuilder useBgImgColor(boolean useBgImgColor) {
            this.useBgImgColor = useBgImgColor;
            this.useBgImgColor$set = true;
            return this;
        }

        public QrCodeConfigBuilder imageType(ImageType imageType) {
            this.imageType = imageType;
            this.imageType$set = true;
            return this;
        }

        public QrCodeConfigBuilder dataShape(QrCodeDataShape dataShape) {
            this.dataShape = dataShape;
            this.dataShape$set = true;
            return this;
        }

        public QrCodeConfigBuilder errorCorrectionLevel(ErrorCorrectionLevel errorCorrectionLevel) {
            this.errorCorrectionLevel = errorCorrectionLevel;
            this.errorCorrectionLevel$set = true;
            return this;
        }

        public QrCodeConfigBuilder logo(String logo) {
            this.logo = logo;
            return this;
        }

        public QrCodeConfigBuilder logoSizeRatio(int logoSizeRatio) {
            this.logoSizeRatio = logoSizeRatio;
            this.logoSizeRatio$set = true;
            return this;
        }

        public QrCodeConfigBuilder logoRoundCorner(boolean logoRoundCorner) {
            this.logoRoundCorner = logoRoundCorner;
            this.logoRoundCorner$set = true;
            return this;
        }

        public QrCodeConfigBuilder logoRadius(int logoRadius) {
            this.logoRadius = logoRadius;
            this.logoRadius$set = true;
            return this;
        }

        public QrCodeConfigBuilder logoBorder(boolean logoBorder) {
            this.logoBorder = logoBorder;
            this.logoBorder$set = true;
            return this;
        }

        public QrCodeConfigBuilder logoBroderSizeRatio(int logoBroderSizeRatio) {
            this.logoBroderSizeRatio = logoBroderSizeRatio;
            this.logoBroderSizeRatio$set = true;
            return this;
        }

        public QrCodeConfigBuilder logoBorderColor(String logoBorderColor) {
            this.logoBorderColor = logoBorderColor;
            this.logoBorderColor$set = true;
            return this;
        }

        public QrCodeConfig build() {
            return new QrCodeConfig(this.msg, this.charset$set ? this.charset : QrCodeConfig.$default$charset(), this.size$set ? this.size : QrCodeConfig.$default$size(), this.padding$set ? this.padding : QrCodeConfig.$default$padding(), this.paddingStrict$set ? this.paddingStrict : QrCodeConfig.$default$paddingStrict(), this.offColor$set ? this.offColor : QrCodeConfig.$default$offColor(), this.onColor$set ? this.onColor : QrCodeConfig.$default$onColor(), this.gradientOnColor$set ? this.gradientOnColor : QrCodeConfig.$default$gradientOnColor(), this.gradientType$set ? this.gradientType : QrCodeConfig.$default$gradientType(), this.bgImage, this.bgImgOpacity$set ? this.bgImgOpacity : QrCodeConfig.$default$bgImgOpacity(), this.detectOutColor$set ? this.detectOutColor : QrCodeConfig.$default$detectOutColor(), this.detectInColor$set ? this.detectInColor : QrCodeConfig.$default$detectInColor(), this.useBgImgColor$set ? this.useBgImgColor : QrCodeConfig.$default$useBgImgColor(), this.imageType$set ? this.imageType : QrCodeConfig.$default$imageType(), this.dataShape$set ? this.dataShape : QrCodeConfig.$default$dataShape(), this.errorCorrectionLevel$set ? this.errorCorrectionLevel : QrCodeConfig.$default$errorCorrectionLevel(), this.logo, this.logoSizeRatio$set ? this.logoSizeRatio : QrCodeConfig.$default$logoSizeRatio(), this.logoRoundCorner$set ? this.logoRoundCorner : QrCodeConfig.$default$logoRoundCorner(), this.logoRadius$set ? this.logoRadius : QrCodeConfig.$default$logoRadius(), this.logoBorder$set ? this.logoBorder : QrCodeConfig.$default$logoBorder(), this.logoBroderSizeRatio$set ? this.logoBroderSizeRatio : QrCodeConfig.$default$logoBroderSizeRatio(), this.logoBorderColor$set ? this.logoBorderColor : QrCodeConfig.$default$logoBorderColor());
        }

        public String toString() {
            return "QrCodeConfig.QrCodeConfigBuilder(msg=" + this.msg + ", charset=" + this.charset + ", size=" + this.size + ", padding=" + this.padding + ", paddingStrict=" + this.paddingStrict + ", offColor=" + this.offColor + ", onColor=" + this.onColor + ", gradientOnColor=" + this.gradientOnColor + ", gradientType=" + (Object)((Object)this.gradientType) + ", bgImage=" + this.bgImage + ", bgImgOpacity=" + this.bgImgOpacity + ", detectOutColor=" + this.detectOutColor + ", detectInColor=" + this.detectInColor + ", useBgImgColor=" + this.useBgImgColor + ", imageType=" + (Object)((Object)this.imageType) + ", dataShape=" + (Object)((Object)this.dataShape) + ", errorCorrectionLevel=" + this.errorCorrectionLevel + ", logo=" + this.logo + ", logoSizeRatio=" + this.logoSizeRatio + ", logoRoundCorner=" + this.logoRoundCorner + ", logoRadius=" + this.logoRadius + ", logoBorder=" + this.logoBorder + ", logoBroderSizeRatio=" + this.logoBroderSizeRatio + ", logoBorderColor=" + this.logoBorderColor + ")";
        }
    }

    public static class InternalBuilder
    extends QrCodeConfigBuilder {
        InternalBuilder() {
        }

        @Override
        public QrCodeConfig build() {
            QrCodeConfig config = super.build();
            config.validateParams();
            return config;
        }
    }
}

