/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.job.event.store.domain;

import cn.patterncat.job.event.JobEvent;
import cn.patterncat.job.event.JobEventType;
import cn.patterncat.job.event.JobType;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Version;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class JobLog {
    @Id
    private String id;
    String jobId;
    JobEventType jobEventType;
    JobType jobType;
    long eventTimestamp;
    long future;
    long frequency;
    String namespace;
    String workerName;
    String queue;
    String jobClass;
    Object[] jobArgs;
    Map<String, Object> jobVars;
    Map<String, Object> jobUnknownFields;
    String runner;
    Object result;
    String throwable;
    private Date createTime;
    @Version
    private Long version;

    public static JobLog from(JobEvent jobEvent) {
        JobLog log = JobLog.builder().jobType(jobEvent.getJobType()).jobEventType(jobEvent.getJobEventType()).queue(jobEvent.getQueue()).namespace(jobEvent.getNamespace()).workerName(jobEvent.getWorker()).createTime(new Date()).eventTimestamp(jobEvent.getTimestamp()).frequency(jobEvent.getFrequency()).future(jobEvent.getFuture()).jobClass(jobEvent.getJobClassName()).jobId(Objects.toString(jobEvent.getJobUnknownFields().get("jobId"), "")).jobArgs(jobEvent.getJobArgs()).jobVars(jobEvent.getJobVars()).jobUnknownFields(jobEvent.getJobUnknownFields()).runner(jobEvent.getRunnerString()).result(jobEvent.getResult()).throwable(jobEvent.getThrowableString(Integer.MAX_VALUE)).build();
        return log;
    }

    @ConstructorProperties(value={"id", "jobId", "jobEventType", "jobType", "eventTimestamp", "future", "frequency", "namespace", "workerName", "queue", "jobClass", "jobArgs", "jobVars", "jobUnknownFields", "runner", "result", "throwable", "createTime", "version"})
    JobLog(String id, String jobId, JobEventType jobEventType, JobType jobType, long eventTimestamp, long future, long frequency, String namespace, String workerName, String queue, String jobClass, Object[] jobArgs, Map<String, Object> jobVars, Map<String, Object> jobUnknownFields, String runner, Object result, String throwable, Date createTime, Long version) {
        this.id = id;
        this.jobId = jobId;
        this.jobEventType = jobEventType;
        this.jobType = jobType;
        this.eventTimestamp = eventTimestamp;
        this.future = future;
        this.frequency = frequency;
        this.namespace = namespace;
        this.workerName = workerName;
        this.queue = queue;
        this.jobClass = jobClass;
        this.jobArgs = jobArgs;
        this.jobVars = jobVars;
        this.jobUnknownFields = jobUnknownFields;
        this.runner = runner;
        this.result = result;
        this.throwable = throwable;
        this.createTime = createTime;
        this.version = version;
    }

    public static JobLogBuilder builder() {
        return new JobLogBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getJobId() {
        return this.jobId;
    }

    public JobEventType getJobEventType() {
        return this.jobEventType;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public long getEventTimestamp() {
        return this.eventTimestamp;
    }

    public long getFuture() {
        return this.future;
    }

    public long getFrequency() {
        return this.frequency;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getWorkerName() {
        return this.workerName;
    }

    public String getQueue() {
        return this.queue;
    }

    public String getJobClass() {
        return this.jobClass;
    }

    public Object[] getJobArgs() {
        return this.jobArgs;
    }

    public Map<String, Object> getJobVars() {
        return this.jobVars;
    }

    public Map<String, Object> getJobUnknownFields() {
        return this.jobUnknownFields;
    }

    public String getRunner() {
        return this.runner;
    }

    public Object getResult() {
        return this.result;
    }

    public String getThrowable() {
        return this.throwable;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public void setJobEventType(JobEventType jobEventType) {
        this.jobEventType = jobEventType;
    }

    public void setJobType(JobType jobType) {
        this.jobType = jobType;
    }

    public void setEventTimestamp(long eventTimestamp) {
        this.eventTimestamp = eventTimestamp;
    }

    public void setFuture(long future) {
        this.future = future;
    }

    public void setFrequency(long frequency) {
        this.frequency = frequency;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setWorkerName(String workerName) {
        this.workerName = workerName;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public void setJobClass(String jobClass) {
        this.jobClass = jobClass;
    }

    public void setJobArgs(Object[] jobArgs) {
        this.jobArgs = jobArgs;
    }

    public void setJobVars(Map<String, Object> jobVars) {
        this.jobVars = jobVars;
    }

    public void setJobUnknownFields(Map<String, Object> jobUnknownFields) {
        this.jobUnknownFields = jobUnknownFields;
    }

    public void setRunner(String runner) {
        this.runner = runner;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public void setThrowable(String throwable) {
        this.throwable = throwable;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobLog)) {
            return false;
        }
        JobLog other = (JobLog)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$jobId = this.getJobId();
        String other$jobId = other.getJobId();
        if (this$jobId == null ? other$jobId != null : !this$jobId.equals(other$jobId)) {
            return false;
        }
        JobEventType this$jobEventType = this.getJobEventType();
        JobEventType other$jobEventType = other.getJobEventType();
        if (this$jobEventType == null ? other$jobEventType != null : !this$jobEventType.equals(other$jobEventType)) {
            return false;
        }
        JobType this$jobType = this.getJobType();
        JobType other$jobType = other.getJobType();
        if (this$jobType == null ? other$jobType != null : !this$jobType.equals(other$jobType)) {
            return false;
        }
        if (this.getEventTimestamp() != other.getEventTimestamp()) {
            return false;
        }
        if (this.getFuture() != other.getFuture()) {
            return false;
        }
        if (this.getFrequency() != other.getFrequency()) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$workerName = this.getWorkerName();
        String other$workerName = other.getWorkerName();
        if (this$workerName == null ? other$workerName != null : !this$workerName.equals(other$workerName)) {
            return false;
        }
        String this$queue = this.getQueue();
        String other$queue = other.getQueue();
        if (this$queue == null ? other$queue != null : !this$queue.equals(other$queue)) {
            return false;
        }
        String this$jobClass = this.getJobClass();
        String other$jobClass = other.getJobClass();
        if (this$jobClass == null ? other$jobClass != null : !this$jobClass.equals(other$jobClass)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getJobArgs(), other.getJobArgs())) {
            return false;
        }
        Map<String, Object> this$jobVars = this.getJobVars();
        Map<String, Object> other$jobVars = other.getJobVars();
        if (this$jobVars == null ? other$jobVars != null : !((Object)this$jobVars).equals(other$jobVars)) {
            return false;
        }
        Map<String, Object> this$jobUnknownFields = this.getJobUnknownFields();
        Map<String, Object> other$jobUnknownFields = other.getJobUnknownFields();
        if (this$jobUnknownFields == null ? other$jobUnknownFields != null : !((Object)this$jobUnknownFields).equals(other$jobUnknownFields)) {
            return false;
        }
        String this$runner = this.getRunner();
        String other$runner = other.getRunner();
        if (this$runner == null ? other$runner != null : !this$runner.equals(other$runner)) {
            return false;
        }
        Object this$result = this.getResult();
        Object other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        String this$throwable = this.getThrowable();
        String other$throwable = other.getThrowable();
        if (this$throwable == null ? other$throwable != null : !this$throwable.equals(other$throwable)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !((Object)this$version).equals(other$version));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobLog;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $jobId = this.getJobId();
        result = result * 59 + ($jobId == null ? 43 : $jobId.hashCode());
        JobEventType $jobEventType = this.getJobEventType();
        result = result * 59 + ($jobEventType == null ? 43 : $jobEventType.hashCode());
        JobType $jobType = this.getJobType();
        result = result * 59 + ($jobType == null ? 43 : $jobType.hashCode());
        long $eventTimestamp = this.getEventTimestamp();
        result = result * 59 + (int)($eventTimestamp >>> 32 ^ $eventTimestamp);
        long $future = this.getFuture();
        result = result * 59 + (int)($future >>> 32 ^ $future);
        long $frequency = this.getFrequency();
        result = result * 59 + (int)($frequency >>> 32 ^ $frequency);
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $workerName = this.getWorkerName();
        result = result * 59 + ($workerName == null ? 43 : $workerName.hashCode());
        String $queue = this.getQueue();
        result = result * 59 + ($queue == null ? 43 : $queue.hashCode());
        String $jobClass = this.getJobClass();
        result = result * 59 + ($jobClass == null ? 43 : $jobClass.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getJobArgs());
        Map<String, Object> $jobVars = this.getJobVars();
        result = result * 59 + ($jobVars == null ? 43 : ((Object)$jobVars).hashCode());
        Map<String, Object> $jobUnknownFields = this.getJobUnknownFields();
        result = result * 59 + ($jobUnknownFields == null ? 43 : ((Object)$jobUnknownFields).hashCode());
        String $runner = this.getRunner();
        result = result * 59 + ($runner == null ? 43 : $runner.hashCode());
        Object $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        String $throwable = this.getThrowable();
        result = result * 59 + ($throwable == null ? 43 : $throwable.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        return result;
    }

    public String toString() {
        return "JobLog(id=" + this.getId() + ", jobId=" + this.getJobId() + ", jobEventType=" + this.getJobEventType() + ", jobType=" + this.getJobType() + ", eventTimestamp=" + this.getEventTimestamp() + ", future=" + this.getFuture() + ", frequency=" + this.getFrequency() + ", namespace=" + this.getNamespace() + ", workerName=" + this.getWorkerName() + ", queue=" + this.getQueue() + ", jobClass=" + this.getJobClass() + ", jobArgs=" + Arrays.deepToString(this.getJobArgs()) + ", jobVars=" + this.getJobVars() + ", jobUnknownFields=" + this.getJobUnknownFields() + ", runner=" + this.getRunner() + ", result=" + this.getResult() + ", throwable=" + this.getThrowable() + ", createTime=" + this.getCreateTime() + ", version=" + this.getVersion() + ")";
    }

    public static class JobLogBuilder {
        private String id;
        private String jobId;
        private JobEventType jobEventType;
        private JobType jobType;
        private long eventTimestamp;
        private long future;
        private long frequency;
        private String namespace;
        private String workerName;
        private String queue;
        private String jobClass;
        private Object[] jobArgs;
        private Map<String, Object> jobVars;
        private Map<String, Object> jobUnknownFields;
        private String runner;
        private Object result;
        private String throwable;
        private Date createTime;
        private Long version;

        JobLogBuilder() {
        }

        public JobLogBuilder id(String id) {
            this.id = id;
            return this;
        }

        public JobLogBuilder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public JobLogBuilder jobEventType(JobEventType jobEventType) {
            this.jobEventType = jobEventType;
            return this;
        }

        public JobLogBuilder jobType(JobType jobType) {
            this.jobType = jobType;
            return this;
        }

        public JobLogBuilder eventTimestamp(long eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
            return this;
        }

        public JobLogBuilder future(long future) {
            this.future = future;
            return this;
        }

        public JobLogBuilder frequency(long frequency) {
            this.frequency = frequency;
            return this;
        }

        public JobLogBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public JobLogBuilder workerName(String workerName) {
            this.workerName = workerName;
            return this;
        }

        public JobLogBuilder queue(String queue) {
            this.queue = queue;
            return this;
        }

        public JobLogBuilder jobClass(String jobClass) {
            this.jobClass = jobClass;
            return this;
        }

        public JobLogBuilder jobArgs(Object[] jobArgs) {
            this.jobArgs = jobArgs;
            return this;
        }

        public JobLogBuilder jobVars(Map<String, Object> jobVars) {
            this.jobVars = jobVars;
            return this;
        }

        public JobLogBuilder jobUnknownFields(Map<String, Object> jobUnknownFields) {
            this.jobUnknownFields = jobUnknownFields;
            return this;
        }

        public JobLogBuilder runner(String runner) {
            this.runner = runner;
            return this;
        }

        public JobLogBuilder result(Object result) {
            this.result = result;
            return this;
        }

        public JobLogBuilder throwable(String throwable) {
            this.throwable = throwable;
            return this;
        }

        public JobLogBuilder createTime(Date createTime) {
            this.createTime = createTime;
            return this;
        }

        public JobLogBuilder version(Long version) {
            this.version = version;
            return this;
        }

        public JobLog build() {
            return new JobLog(this.id, this.jobId, this.jobEventType, this.jobType, this.eventTimestamp, this.future, this.frequency, this.namespace, this.workerName, this.queue, this.jobClass, this.jobArgs, this.jobVars, this.jobUnknownFields, this.runner, this.result, this.throwable, this.createTime, this.version);
        }

        public String toString() {
            return "JobLog.JobLogBuilder(id=" + this.id + ", jobId=" + this.jobId + ", jobEventType=" + this.jobEventType + ", jobType=" + this.jobType + ", eventTimestamp=" + this.eventTimestamp + ", future=" + this.future + ", frequency=" + this.frequency + ", namespace=" + this.namespace + ", workerName=" + this.workerName + ", queue=" + this.queue + ", jobClass=" + this.jobClass + ", jobArgs=" + Arrays.deepToString(this.jobArgs) + ", jobVars=" + this.jobVars + ", jobUnknownFields=" + this.jobUnknownFields + ", runner=" + this.runner + ", result=" + this.result + ", throwable=" + this.throwable + ", createTime=" + this.createTime + ", version=" + this.version + ")";
        }
    }
}

