package org.springframework.cloud.sleuth.instrument.web;

import brave.ErrorParser;
import brave.http.HttpClientParser;
import brave.http.HttpServerParser;
import cn.patterncat.tracing.ExtraTracingProperties;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Created by cat on 2019-01-23.
 */
@Configuration
@AutoConfigureBefore(TraceHttpAutoConfiguration.class)
@EnableConfigurationProperties({ TraceKeys.class, SleuthHttpLegacyProperties.class, ExtraTracingProperties.class})
@ConditionalOnProperty(name = "spring.sleuth.http.status.enabled", havingValue = "true", matchIfMissing = true)
public class ExtraHttpStatusConfiguration {

    @Bean
    @ConditionalOnProperty(name = "spring.sleuth.http.legacy.enabled", havingValue = "false", matchIfMissing = true)
    HttpClientParser httpClientParser(TraceKeys traceKeys, ExtraTracingProperties properties) {
        return new ExtraSleuthHttpClientParser(traceKeys,properties);
    }

    @Bean
    @ConditionalOnProperty(name = "spring.sleuth.http.legacy.enabled", havingValue = "false", matchIfMissing = true)
    HttpServerParser defaultHttpServerParser(TraceKeys traceKeys, ExtraTracingProperties properties,
                                            ErrorParser errorParser) {
        return new ExtraSleuthHttpServerParser(traceKeys, properties, errorParser);
    }
}
