package cn.patterncat.tracing.helper;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * Created by cat on 2019-01-26.
 */
public class MaskHelper {

    private static final Logger LOGGER = LoggerFactory.getLogger(MaskHelper.class);

    public static Pattern DEFAULT = Pattern.compile("(password)=([^&]*)");

    //整个password=abc算是group(0)，password算group(1)，abc算group(2)
    public static int DEFAULT_REPLACE_GROUP = 2;

    public static Pattern buildMaskPattern(Set<String> keys){
        if(CollectionUtils.isEmpty(keys)){
            return DEFAULT;
        }
        try{
            String regex = "(" + keys.stream().collect(Collectors.joining("|")) + ")=([^&]*)";
            return Pattern.compile(regex);
        }catch (Exception e){
            LOGGER.warn(e.getMessage(),e);
        }
        return DEFAULT;
    }

    //参数在url或者在表单中，其形式一样，都是key=value，用&拼接
    //value中如果包含&一般会被转义为%26
    //pattern诸如(password|idcard)=([^&]*)
    public static String maskQueryString(String query, Pattern pattern, int replaceGroup, String replacement){
//        if(StringUtils.isEmpty(query)){
//            return query;
//        }
        Matcher matcher = pattern.matcher(query);
        StringBuilder builder = new StringBuilder(query);
        int delta = 0;
        while (matcher.find()) {
            if(replaceGroup > matcher.groupCount()){
                continue;
            }
            int start = matcher.start(replaceGroup);
            int end = matcher.end(replaceGroup);
            builder.replace(start - delta,end - delta,replacement);
            delta = delta + end - start - replacement.length();
        }
        return builder.toString();
    }
}
