/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import cn.patterncat.tracing.component.resttemplate.ExtraTracingClientHttpRequestInterceptor;
import java.io.IOException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

class LazyTracingClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private final BeanFactory beanFactory;
    private ExtraTracingClientHttpRequestInterceptor interceptor;

    public LazyTracingClientHttpRequestInterceptor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        return this.interceptor().intercept(request, body, execution);
    }

    private ExtraTracingClientHttpRequestInterceptor interceptor() {
        if (this.interceptor == null) {
            this.interceptor = (ExtraTracingClientHttpRequestInterceptor)this.beanFactory.getBean(ExtraTracingClientHttpRequestInterceptor.class);
        }
        return this.interceptor;
    }
}

