/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import brave.ErrorParser;
import brave.SpanCustomizer;
import brave.http.HttpAdapter;
import org.springframework.cloud.sleuth.instrument.web.SleuthHttpServerParser;
import org.springframework.cloud.sleuth.instrument.web.TraceKeys;

public class ExtraSleuthHttpServerParser
extends SleuthHttpServerParser {
    private static final String STATUS_CODE_KEY = "http.status";

    ExtraSleuthHttpServerParser(TraceKeys traceKeys, ErrorParser errorParser) {
        super(traceKeys, errorParser);
    }

    public <Resp> void response(HttpAdapter<?, Resp> adapter, Resp res, Throwable error, SpanCustomizer customizer) {
        super.response(adapter, res, error, customizer);
        Integer httpStatus = adapter.statusCode(res);
        if (200 == httpStatus && error == null) {
            customizer.tag(STATUS_CODE_KEY, String.valueOf(200));
        }
    }
}

