/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import brave.ErrorParser;
import brave.http.HttpClientParser;
import brave.http.HttpServerParser;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.instrument.web.ExtraSleuthHttpClientParser;
import org.springframework.cloud.sleuth.instrument.web.ExtraSleuthHttpServerParser;
import org.springframework.cloud.sleuth.instrument.web.SleuthHttpLegacyProperties;
import org.springframework.cloud.sleuth.instrument.web.TraceHttpAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.web.TraceKeys;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={TraceHttpAutoConfiguration.class})
@EnableConfigurationProperties(value={TraceKeys.class, SleuthHttpLegacyProperties.class})
@ConditionalOnProperty(name={"spring.sleuth.http.status.enabled"}, havingValue="true", matchIfMissing=true)
public class ExtraHttpStatusConfiguration {
    @Bean
    @ConditionalOnProperty(name={"spring.sleuth.http.legacy.enabled"}, havingValue="false", matchIfMissing=true)
    HttpClientParser httpClientParser(TraceKeys traceKeys) {
        return new ExtraSleuthHttpClientParser(traceKeys);
    }

    @Bean
    @ConditionalOnProperty(name={"spring.sleuth.http.legacy.enabled"}, havingValue="false", matchIfMissing=true)
    HttpServerParser defaultHttpServerParser(TraceKeys traceKeys, ErrorParser errorParser) {
        return new ExtraSleuthHttpServerParser(traceKeys, errorParser);
    }
}

