/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.tracing.config.mvc;

import brave.SpanCustomizer;
import cn.patterncat.tracing.ExtraTracingProperties;
import cn.patterncat.tracing.component.servlet.MultiReadableHttpServletRequest;
import cn.patterncat.tracing.helper.HttpBodyTraceHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableConfigurationProperties(value={ExtraTracingProperties.class})
public class ExtraTagMvcInterceptor
implements HandlerInterceptor,
WebMvcConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtraTagMvcInterceptor.class);
    private final ExtraTracingProperties properties;

    public ExtraTagMvcInterceptor(ExtraTracingProperties properties) {
        this.properties = properties;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        SpanCustomizer span = (SpanCustomizer)request.getAttribute(SpanCustomizer.class.getName());
        span.tag(this.properties.getServletRequestQueryTag(), Objects.toString(request.getQueryString(), ""));
        if (this.properties.isExtraServletHeaderEnabled() && this.properties.getTraceTagHeaderMappings() != null && !this.properties.getTraceTagHeaderMappings().isEmpty()) {
            this.properties.getTraceTagHeaderMappings().entrySet().stream().forEach(entry -> {
                String tagName = (String)entry.getKey();
                String headerNames = (String)entry.getValue();
                if (!StringUtils.hasText((String)tagName) || !StringUtils.hasText((String)headerNames)) {
                    LOGGER.error("detect invalid traceTagHeaderMappings: {}", entry);
                    return;
                }
                Optional<String> result = Arrays.stream(headerNames.split(this.properties.getTagMultiHeaderSeparator())).map(name -> Objects.toString(request.getHeader(name), "")).filter(e -> !StringUtils.isEmpty((Object)e)).findFirst();
                span.tag(tagName, result.orElse(""));
            });
        }
        if (this.properties.isTraceServletRequestBody() && request instanceof MultiReadableHttpServletRequest && HttpBodyTraceHelper.isContentTypePrintable(this.properties.getPrintableMediaSubTypes(), request.getContentType())) {
            MultiReadableHttpServletRequest wrapper = (MultiReadableHttpServletRequest)request;
            try {
                byte[] data = StreamUtils.copyToByteArray((InputStream)wrapper.getInputStream());
                String requestBody = HttpBodyTraceHelper.getContentAsString(data, this.properties.getMaxPrintBodyBytes(), request.getCharacterEncoding());
                span.tag(this.properties.getServletRequestBodyTag(), requestBody);
                LOGGER.debug("request body:{}", (Object)requestBody);
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.properties.isTraceSpringMvcUrlPattern()) {
            String urlPattern = Objects.toString(request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE), "");
            span.tag(this.properties.getSpringMvcUrlPatternTag(), urlPattern);
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this);
    }
}

