/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.tracing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.http.MediaType;

@ConfigurationProperties(prefix="extra.tracing")
public class ExtraTracingProperties {
    private boolean enabled = true;
    private boolean traceServletRequestBody = true;
    private List<String> printableMediaSubTypes = new ArrayList<String>(){
        {
            this.add(MediaType.APPLICATION_FORM_URLENCODED.getSubtype());
            this.add(MediaType.APPLICATION_JSON.getSubtype());
            this.add(MediaType.APPLICATION_XML.getSubtype());
            this.add(MediaType.TEXT_PLAIN.getSubtype());
        }
    };
    private int maxPrintBodyBytes = 2048;
    private String servletRequestQueryTag = "http.query";
    private String servletRequestBodyTag = "http.body";
    private boolean traceSpringMvcUrlPattern = false;
    private String springMvcUrlPatternTag = "http.urlPattern";
    private boolean traceRestTemplateRequestBody = true;
    private String httpRequestBodyTag = "http.body";
    private String httpRequestQueryTag = "http.query";
    private boolean extraServletHeaderEnabled = true;
    private String tagMultiHeaderSeparator = ",";
    private Map<String, String> traceTagHeaderMappings = new HashMap<String, String>();

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isTraceServletRequestBody() {
        return this.traceServletRequestBody;
    }

    public List<String> getPrintableMediaSubTypes() {
        return this.printableMediaSubTypes;
    }

    public int getMaxPrintBodyBytes() {
        return this.maxPrintBodyBytes;
    }

    public String getServletRequestQueryTag() {
        return this.servletRequestQueryTag;
    }

    public String getServletRequestBodyTag() {
        return this.servletRequestBodyTag;
    }

    public boolean isTraceSpringMvcUrlPattern() {
        return this.traceSpringMvcUrlPattern;
    }

    public String getSpringMvcUrlPatternTag() {
        return this.springMvcUrlPatternTag;
    }

    public boolean isTraceRestTemplateRequestBody() {
        return this.traceRestTemplateRequestBody;
    }

    public String getHttpRequestBodyTag() {
        return this.httpRequestBodyTag;
    }

    public String getHttpRequestQueryTag() {
        return this.httpRequestQueryTag;
    }

    public boolean isExtraServletHeaderEnabled() {
        return this.extraServletHeaderEnabled;
    }

    public String getTagMultiHeaderSeparator() {
        return this.tagMultiHeaderSeparator;
    }

    public Map<String, String> getTraceTagHeaderMappings() {
        return this.traceTagHeaderMappings;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setTraceServletRequestBody(boolean traceServletRequestBody) {
        this.traceServletRequestBody = traceServletRequestBody;
    }

    public void setPrintableMediaSubTypes(List<String> printableMediaSubTypes) {
        this.printableMediaSubTypes = printableMediaSubTypes;
    }

    public void setMaxPrintBodyBytes(int maxPrintBodyBytes) {
        this.maxPrintBodyBytes = maxPrintBodyBytes;
    }

    public void setServletRequestQueryTag(String servletRequestQueryTag) {
        this.servletRequestQueryTag = servletRequestQueryTag;
    }

    public void setServletRequestBodyTag(String servletRequestBodyTag) {
        this.servletRequestBodyTag = servletRequestBodyTag;
    }

    public void setTraceSpringMvcUrlPattern(boolean traceSpringMvcUrlPattern) {
        this.traceSpringMvcUrlPattern = traceSpringMvcUrlPattern;
    }

    public void setSpringMvcUrlPatternTag(String springMvcUrlPatternTag) {
        this.springMvcUrlPatternTag = springMvcUrlPatternTag;
    }

    public void setTraceRestTemplateRequestBody(boolean traceRestTemplateRequestBody) {
        this.traceRestTemplateRequestBody = traceRestTemplateRequestBody;
    }

    public void setHttpRequestBodyTag(String httpRequestBodyTag) {
        this.httpRequestBodyTag = httpRequestBodyTag;
    }

    public void setHttpRequestQueryTag(String httpRequestQueryTag) {
        this.httpRequestQueryTag = httpRequestQueryTag;
    }

    public void setExtraServletHeaderEnabled(boolean extraServletHeaderEnabled) {
        this.extraServletHeaderEnabled = extraServletHeaderEnabled;
    }

    public void setTagMultiHeaderSeparator(String tagMultiHeaderSeparator) {
        this.tagMultiHeaderSeparator = tagMultiHeaderSeparator;
    }

    public void setTraceTagHeaderMappings(Map<String, String> traceTagHeaderMappings) {
        this.traceTagHeaderMappings = traceTagHeaderMappings;
    }
}

