package org.springframework.cloud.sleuth.instrument.web;

import brave.ErrorParser;
import brave.SpanCustomizer;
import brave.http.HttpAdapter;

import javax.servlet.http.HttpServletResponse;

/**
 * Created by cat on 2019-01-23.
 */
public class ExtraSleuthHttpServerParser extends SleuthHttpServerParser{
    private static final String STATUS_CODE_KEY = "http.status";

    ExtraSleuthHttpServerParser(TraceKeys traceKeys, ErrorParser errorParser) {
        super(traceKeys, errorParser);
    }

    @Override
    public <Resp> void response(HttpAdapter<?, Resp> adapter, Resp res, Throwable error, SpanCustomizer customizer) {
        super.response(adapter, res, error, customizer);
        Integer httpStatus = adapter.statusCode(res);
        if (HttpServletResponse.SC_OK == httpStatus && error == null) {
            customizer.tag(STATUS_CODE_KEY,
                    String.valueOf(HttpServletResponse.SC_OK));
        }
    }
}
