package org.springframework.cloud.sleuth.instrument.web;

import brave.SpanCustomizer;
import brave.http.HttpAdapter;

/**
 * Created by cat on 2019-01-23.
 */
public class ExtraSleuthHttpClientParser extends SleuthHttpClientParser{
    private static final String STATUS_CODE_KEY = "http.status";

    ExtraSleuthHttpClientParser(TraceKeys traceKeys) {
        super(traceKeys);
    }

    @Override
    public <Resp> void response(HttpAdapter<?, Resp> adapter, Resp res, Throwable error, SpanCustomizer customizer) {
        super.response(adapter, res, error, customizer);
        int statusCode = adapter.statusCodeAsInt(res);
        customizer.tag(STATUS_CODE_KEY, String.valueOf(statusCode));
    }
}
