package cn.patterncat.tracing.config.servlet;

import cn.patterncat.tracing.component.servlet.MultiReadableHttpServletRequestFilter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.cloud.sleuth.instrument.web.*;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * https://cloud.spring.io/spring-cloud-sleuth/single/spring-cloud-sleuth.html#_sending_spans_to_zipkin
 * Created by cat on 2018-12-04.
 */
@Configuration
@ConditionalOnProperty(
        prefix = "extra.tracing",
        name = "traceServletRequestBody",
        havingValue = "true",
        matchIfMissing = false
)
@AutoConfigureBefore(TraceHttpAutoConfiguration.class)
public class MultiReadableServletRequestConfig {

    @Bean
    public FilterRegistrationBean multiReadableHttpServletRequestFilterRegistrationBean() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        MultiReadableHttpServletRequestFilter multiReadableHttpServletRequestFilter = new MultiReadableHttpServletRequestFilter();
        registrationBean.setFilter(multiReadableHttpServletRequestFilter);
        registrationBean.setOrder(1);
        return registrationBean;
    }
}
