package cn.patterncat.tracing;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.http.MediaType;
import java.util.*;

/**
 * Created by cat on 2018-12-05.
 */
@Getter
@Setter
@ConfigurationProperties(prefix = "extra.tracing")
public class ExtraTracingProperties {

    private boolean enabled = true;

    private boolean traceServletRequestBody = true;

    private List<String> printableMediaSubTypes = new ArrayList<String>(){{
        add(MediaType.APPLICATION_FORM_URLENCODED.getSubtype()); // x-www-form-urlencoded
        add(MediaType.APPLICATION_JSON.getSubtype());  //json
        add(MediaType.APPLICATION_XML.getSubtype()); // xml
//        add(MediaType.TEXT_HTML.getSubtype()); //html, sac接口返回的是text/html
//        add(MediaType.TEXT_MARKDOWN.getSubtype()); //markdown
        add(MediaType.TEXT_PLAIN.getSubtype()); //plain
//        add(MediaType.TEXT_XML.getSubtype()); //xml
    }};

    private int maxPrintBodyBytes = 2048;

    private String servletRequestQueryTag = "http.query";

    private String servletRequestBodyTag = "http.body";

    private boolean traceSpringMvcUrlPattern = false;

    private String springMvcUrlPatternTag = "http.urlPattern";

    private boolean traceRestTemplateRequestBody = true;

    private String httpRequestBodyTag = "http.body";

    private String httpRequestQueryTag = "http.query";

    private boolean extraServletHeaderEnabled = true;

    private String tagMultiHeaderSeparator = ",";

    //tag name --> header name, if multi header name maps to one tag, use first non empty value in order
    private Map<String,String> traceTagHeaderMappings = new HashMap<>();

}
