/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import brave.http.HttpTracing;
import brave.httpasyncclient.TracingHttpAsyncClientBuilder;
import brave.httpclient.TracingHttpClientBuilder;
import cn.patterncat.tracing.ExtraTracingProperties;
import cn.patterncat.tracing.component.ExtraTracingClientHttpRequestInterceptor;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoRestTemplateCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.cloud.commons.httpclient.HttpClientConfiguration;
import org.springframework.cloud.sleuth.instrument.web.TraceHttpAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.web.TraceWebServletAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.web.client.HttpClientBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.web.client.TraceRestTemplateBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.web.client.TraceRestTemplateCustomizer;
import org.springframework.cloud.sleuth.instrument.web.client.TraceUserInfoRestTemplateCustomizer;
import org.springframework.cloud.sleuth.instrument.web.client.TraceWebClientBeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;

@Configuration
@AutoConfigureBefore(value={HttpClientConfiguration.class})
@AutoConfigureAfter(value={TraceWebServletAutoConfiguration.class, TraceHttpAutoConfiguration.class})
@ConditionalOnProperty(name={"spring.sleuth.http.enabled"}, havingValue="true", matchIfMissing=true)
public class ExtraTraceWebClientAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={UserInfoRestTemplateCustomizer.class, OAuth2RestTemplate.class})
    protected static class TraceOAuthConfiguration {
        protected TraceOAuthConfiguration() {
        }

        @Bean
        UserInfoRestTemplateCustomizerBPP userInfoRestTemplateCustomizerBeanPostProcessor(BeanFactory beanFactory) {
            return new UserInfoRestTemplateCustomizerBPP(beanFactory);
        }

        @Bean
        @ConditionalOnMissingBean
        UserInfoRestTemplateCustomizer traceUserInfoRestTemplateCustomizer(BeanFactory beanFactory) {
            return new TraceUserInfoRestTemplateCustomizer(beanFactory);
        }

        private static class UserInfoRestTemplateCustomizerBPP
        implements BeanPostProcessor {
            private final BeanFactory beanFactory;

            UserInfoRestTemplateCustomizerBPP(BeanFactory beanFactory) {
                this.beanFactory = beanFactory;
            }

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                BeanFactory beanFactory = this.beanFactory;
                if (bean instanceof UserInfoRestTemplateCustomizer && !(bean instanceof ExtraTracingClientHttpRequestInterceptor)) {
                    return new TraceUserInfoRestTemplateCustomizer(beanFactory, bean);
                }
                return bean;
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={HttpClient.class})
    static class NettyConfiguration {
        NettyConfiguration() {
        }

        @Bean
        public HttpClientBeanPostProcessor httpClientBeanPostProcessor(BeanFactory beanFactory) {
            return new HttpClientBeanPostProcessor(beanFactory);
        }
    }

    @Configuration
    @ConditionalOnClass(value={WebClient.class})
    static class WebClientConfig {
        WebClientConfig() {
        }

        @Bean
        static TraceWebClientBeanPostProcessor traceWebClientBeanPostProcessor(BeanFactory beanFactory) {
            return new TraceWebClientBeanPostProcessor(beanFactory);
        }
    }

    @Configuration
    @ConditionalOnClass(value={HttpAsyncClientBuilder.class})
    static class HttpAsyncClientBuilderConfig {
        HttpAsyncClientBuilderConfig() {
        }

        @Bean
        @ConditionalOnMissingBean
        HttpAsyncClientBuilder traceHttpAsyncClientBuilder(HttpTracing httpTracing) {
            return TracingHttpAsyncClientBuilder.create((HttpTracing)httpTracing);
        }
    }

    @Configuration
    @ConditionalOnClass(value={HttpClientBuilder.class})
    static class HttpClientBuilderConfig {
        HttpClientBuilderConfig() {
        }

        @Bean
        @ConditionalOnMissingBean
        HttpClientBuilder traceHttpClientBuilder(HttpTracing httpTracing) {
            return TracingHttpClientBuilder.create((HttpTracing)httpTracing);
        }
    }

    @Configuration
    @ConditionalOnClass(value={RestTemplate.class})
    @EnableConfigurationProperties(value={ExtraTracingProperties.class})
    static class RestTemplateConfig {
        private final ExtraTracingProperties properties;

        public RestTemplateConfig(ExtraTracingProperties properties) {
            this.properties = properties;
        }

        @Bean
        public ExtraTracingClientHttpRequestInterceptor tracingClientHttpRequestInterceptor(HttpTracing httpTracing) {
            return (ExtraTracingClientHttpRequestInterceptor)ExtraTracingClientHttpRequestInterceptor.create(httpTracing, this.properties);
        }

        @Configuration
        protected static class TraceInterceptorConfiguration {
            @Autowired
            private ExtraTracingClientHttpRequestInterceptor clientInterceptor;

            protected TraceInterceptorConfiguration() {
            }

            @Bean
            static TraceRestTemplateBeanPostProcessor traceRestTemplateBPP(ListableBeanFactory beanFactory) {
                return new TraceRestTemplateBeanPostProcessor((BeanFactory)beanFactory);
            }

            @Bean
            @Order
            RestTemplateCustomizer traceRestTemplateCustomizer() {
                return new TraceRestTemplateCustomizer(this.clientInterceptor);
            }
        }
    }
}

