/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.tracing.config;

import brave.SpanCustomizer;
import cn.patterncat.tracing.ExtraTracingProperties;
import cn.patterncat.tracing.component.HttpBodyTraceHelper;
import cn.patterncat.tracing.component.servlet.MultiReadableHttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableConfigurationProperties(value={ExtraTracingProperties.class})
public class ExtraTagInterceptor
implements HandlerInterceptor,
WebMvcConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtraTagInterceptor.class);
    private final ExtraTracingProperties properties;

    public ExtraTagInterceptor(ExtraTracingProperties properties) {
        this.properties = properties;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        SpanCustomizer span = (SpanCustomizer)request.getAttribute(SpanCustomizer.class.getName());
        span.tag(this.properties.getServletRequestQueryTag(), Objects.toString(request.getQueryString(), ""));
        if (this.properties.isExtraServletHeaderEnabled() && this.properties.getTraceTagHeaderMappings() != null && !this.properties.getTraceTagHeaderMappings().isEmpty()) {
            this.properties.getTraceTagHeaderMappings().entrySet().stream().forEach(entry -> {
                String tagName = (String)entry.getKey();
                String headerNames = (String)entry.getValue();
                if (StringUtils.hasText((String)tagName) || StringUtils.hasText((String)headerNames)) {
                    LOGGER.error("detect invalid traceTagHeaderMappings: {}", entry);
                    return;
                }
                Optional<String> result = Arrays.stream(headerNames.split(this.properties.getTagMultiHeaderSeparator())).map(name -> Objects.toString(request.getHeader(name), "")).filter(e -> !StringUtils.isEmpty((Object)e)).findFirst();
                span.tag(tagName, result.orElse(""));
            });
        }
        if (this.properties.isTraceServletRequestBody() && request instanceof MultiReadableHttpServletRequest && HttpBodyTraceHelper.isContentTypePrintable(this.properties.getPrintableMediaSubTypes(), request.getContentType())) {
            MultiReadableHttpServletRequest wrapper = (MultiReadableHttpServletRequest)request;
            try {
                byte[] data = IOUtils.toByteArray((InputStream)wrapper.getInputStream());
                String requestBody = HttpBodyTraceHelper.getContentAsString(data, this.properties.getMaxPrintBodyBytes(), request.getCharacterEncoding());
                span.tag(this.properties.getServletRequestBodyTag(), requestBody);
                LOGGER.debug("request body:{}", (Object)requestBody);
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this);
    }
}

