/*
 * Decompiled with CFR 0.152.
 */
package cn.patterncat.tracing.component;

import java.io.UnsupportedEncodingException;
import java.util.List;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;

public class HttpBodyTraceHelper {
    public static final int MAX_PRINT_BODY_PAYLOAD_BYTES = 2048;

    public static boolean isContentTypePrintable(List<String> printableMediaSubTypes, MediaType contentType) {
        if (contentType != null && printableMediaSubTypes != null) {
            return printableMediaSubTypes.contains(contentType.getSubtype());
        }
        return false;
    }

    public static boolean isContentTypePrintable(List<String> printableMediaSubTypes, String contentTypeStr) {
        if (StringUtils.isEmpty((Object)contentTypeStr) || printableMediaSubTypes == null) {
            return false;
        }
        try {
            MediaType mediaType = MediaType.parseMediaType((String)contentTypeStr);
            if (mediaType != null) {
                return printableMediaSubTypes.contains(mediaType.getSubtype());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static String getContentAsString(byte[] buf, int maxLength, String charsetName) {
        if (buf == null || buf.length == 0) {
            return "";
        }
        int length = Math.min(buf.length, maxLength > 0 ? maxLength : 2048);
        try {
            return new String(buf, 0, length, charsetName);
        }
        catch (UnsupportedEncodingException ex) {
            return "Unsupported Encoding";
        }
    }
}

