/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.redis;

import cn.orionsec.kit.lang.utils.Strings;
import redis.clients.jedis.Jedis;

public class RedisLocks {
    private final Jedis jedis;
    private static final long EXPIRED = 5000L;

    public RedisLocks(Jedis jedis) {
        this.jedis = jedis;
    }

    public long tryLock(String lock) {
        return this.tryLock(lock, 5000L);
    }

    public long tryLock(String lock, long expired) {
        try {
            long lockValue = System.currentTimeMillis() + expired;
            Long r = this.jedis.setnx(lock, String.valueOf(lockValue));
            if (r == 1L) {
                return lockValue;
            }
            long oldLockValue = Long.parseLong(this.jedis.get(lock));
            if (oldLockValue < System.currentTimeMillis()) {
                String getOldLockValue = this.jedis.getSet(lock, String.valueOf(lockValue));
                if (!Strings.isBlank((String)getOldLockValue) && Long.valueOf(getOldLockValue).equals(oldLockValue)) {
                    return lockValue;
                }
                return 0L;
            }
            return 0L;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public void unLock(String lockName, Long lockValue) {
        try {
            String currentLockValue = this.jedis.get(lockName);
            if (!Strings.isBlank((String)currentLockValue) && lockValue.equals(Long.valueOf(currentLockValue))) {
                this.jedis.del(new String[]{lockName});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

