/*
 * Decompiled with CFR 0.152.
 */
package cn.openjava.redis.starter.utils;

import com.google.common.collect.HashMultimap;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Component;

@Component
public class RedisUtil {
    @Autowired
    private RedisTemplate redisTemplate;

    public boolean set(String key, String value) {
        boolean result = false;
        try {
            ValueOperations operations = this.redisTemplate.opsForValue();
            operations.set((Object)key, (Object)value);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean set(String key, String value, Long expireTime) {
        boolean result = false;
        try {
            ValueOperations operations = this.redisTemplate.opsForValue();
            operations.set((Object)key, (Object)value);
            this.redisTemplate.expire((Object)key, expireTime.longValue(), TimeUnit.SECONDS);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void removeByKeys(String ... keys) {
        for (String key : keys) {
            this.remove(key);
        }
    }

    public void removePattern(String pattern) {
        Set keys = this.redisTemplate.keys((Object)pattern);
        if (keys != null && keys.size() > 0) {
            this.redisTemplate.delete((Collection)keys);
        }
    }

    public boolean expire(Object key, Duration duration) {
        return this.redisTemplate.expire(key, duration);
    }

    public void remove(String key) {
        if (this.exists(key).booleanValue()) {
            this.redisTemplate.delete((Object)key);
        }
    }

    public Boolean exists(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public String get(String key) {
        String result = null;
        ValueOperations operations = this.redisTemplate.opsForValue();
        result = (String)operations.get((Object)key);
        return result;
    }

    public void hmSet(String key, String hashKey, String value) {
        HashOperations hash = this.redisTemplate.opsForHash();
        hash.put((Object)key, (Object)hashKey, (Object)value);
    }

    public String hmGet(String key, String hashKey) {
        HashOperations hash = this.redisTemplate.opsForHash();
        return (String)hash.get((Object)key, (Object)hashKey);
    }

    public boolean hmHasKey(String key, String hashKey) {
        HashOperations hash = this.redisTemplate.opsForHash();
        return hash.hasKey((Object)key, (Object)hashKey);
    }

    public long hmRemove(String key, String ... hashKeys) {
        HashOperations hash = this.redisTemplate.opsForHash();
        return hash.delete((Object)key, (Object[])hashKeys);
    }

    public Map<String, String> hashMapGet(String key) {
        HashOperations hash = this.redisTemplate.opsForHash();
        return hash.entries((Object)key);
    }

    public void hashMapSet(String key, Map<String, String> map) {
        HashOperations hash = this.redisTemplate.opsForHash();
        hash.putAll((Object)key, map);
    }

    public void lPush(String key, String value) {
        ListOperations list = this.redisTemplate.opsForList();
        list.leftPush((Object)key, (Object)value);
    }

    public void lRemove(String key, String value) {
        ListOperations list = this.redisTemplate.opsForList();
        list.remove((Object)key, 0L, (Object)value);
    }

    public List<String> lRange(String key, long start, long end) {
        ListOperations list = this.redisTemplate.opsForList();
        return list.range((Object)key, start, end);
    }

    public void add(String key, String value) {
        SetOperations set = this.redisTemplate.opsForSet();
        set.add((Object)key, (Object[])new String[]{value});
    }

    public Set<String> setMembers(String key) {
        SetOperations set = this.redisTemplate.opsForSet();
        return set.members((Object)key);
    }

    public void zAdd(String key, String value, double score) {
        ZSetOperations zSet = this.redisTemplate.opsForZSet();
        zSet.add((Object)key, (Object)value, score);
    }

    public Set<String> rangeByScore(String key, double startScore, double endScore) {
        ZSetOperations zset = this.redisTemplate.opsForZSet();
        return zset.rangeByScore((Object)key, startScore, endScore);
    }

    public Set<String> keys(String pattern) {
        return this.redisTemplate.keys((Object)pattern);
    }

    public List hashMapList(final Collection<String> keySet) {
        return this.redisTemplate.executePipelined((SessionCallback)new SessionCallback<String>(){

            public <K, V> String execute(RedisOperations<K, V> operations) throws DataAccessException {
                HashOperations hashOperations = operations.opsForHash();
                for (String key : keySet) {
                    hashOperations.entries((Object)key);
                }
                return null;
            }
        });
    }

    public void batchHashMapSet(final HashMultimap<String, Map<String, String>> batchMap) {
        this.redisTemplate.expire((Object)"max", 25L, TimeUnit.SECONDS);
        this.redisTemplate.executePipelined((RedisCallback)new RedisCallback<List<Map<String, String>>>(){

            public List<Map<String, String>> doInRedis(RedisConnection connection) throws DataAccessException {
                for (Map.Entry hash : batchMap.entries()) {
                    byte[] hashName = RedisUtil.this.redisTemplate.getStringSerializer().serialize(hash.getKey());
                    Map hashValues = (Map)hash.getValue();
                    Iterator it = hashValues.entrySet().iterator();
                    HashMap<byte[], byte[]> hashes = new HashMap<byte[], byte[]>();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        byte[] key = RedisUtil.this.redisTemplate.getStringSerializer().serialize(entry.getKey());
                        byte[] value = RedisUtil.this.redisTemplate.getStringSerializer().serialize(entry.getValue());
                        hashes.put(key, value);
                    }
                    connection.hMSet(hashName, hashes);
                }
                return null;
            }
        });
    }

    public void batchHashMapSet(final Map<String, Map<String, String>> dataMap) {
        this.redisTemplate.expire((Object)"max", 25L, TimeUnit.SECONDS);
        this.redisTemplate.executePipelined((RedisCallback)new RedisCallback<List<Map<String, String>>>(){

            public List<Map<String, String>> doInRedis(RedisConnection connection) throws DataAccessException {
                for (Map.Entry hash : dataMap.entrySet()) {
                    byte[] hashName = RedisUtil.this.redisTemplate.getStringSerializer().serialize(hash.getKey());
                    Map hashValues = (Map)hash.getValue();
                    Iterator it = hashValues.entrySet().iterator();
                    HashMap<byte[], byte[]> hashes = new HashMap<byte[], byte[]>();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        byte[] key = RedisUtil.this.redisTemplate.getStringSerializer().serialize(entry.getKey());
                        byte[] value = RedisUtil.this.redisTemplate.getStringSerializer().serialize(entry.getValue());
                        hashes.put(key, value);
                    }
                    connection.hMSet(hashName, hashes);
                }
                return null;
            }
        });
    }

    public void batchHashMapListSet(final List<Map<String, Map<String, String>>> list) {
        this.redisTemplate.expire((Object)"max", 25L, TimeUnit.SECONDS);
        this.redisTemplate.executePipelined((RedisCallback)new RedisCallback<List<Map<String, String>>>(){

            public List<Map<String, String>> doInRedis(RedisConnection connection) throws DataAccessException {
                for (Map dataMap : list) {
                    for (Map.Entry hash : dataMap.entrySet()) {
                        byte[] hashName = RedisUtil.this.redisTemplate.getStringSerializer().serialize(hash.getKey());
                        Map hashValues = (Map)hash.getValue();
                        Iterator it = hashValues.entrySet().iterator();
                        HashMap<byte[], byte[]> hashes = new HashMap<byte[], byte[]>();
                        while (it.hasNext()) {
                            Map.Entry entry = it.next();
                            byte[] key = RedisUtil.this.redisTemplate.getStringSerializer().serialize(entry.getKey());
                            byte[] value = RedisUtil.this.redisTemplate.getStringSerializer().serialize(entry.getValue());
                            hashes.put(key, value);
                        }
                        connection.hMSet(hashName, hashes);
                    }
                }
                return null;
            }
        });
    }

    public Long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key);
    }

    public Long getExpire(String key, TimeUnit timeUnit) {
        return this.redisTemplate.getExpire((Object)key, timeUnit);
    }
}

