/*
 * Decompiled with CFR 0.152.
 */
package cn.openjava.openapi.starter.config;

import cn.openjava.openapi.starter.enums.ApiTypeEnum;
import cn.openjava.openapi.starter.properties.OpenApiProperties;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.CorsEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.actuate.endpoint.web.EndpointLinksResolver;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.WebEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.annotation.ServletEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.servlet.WebMvcEndpointHandlerMapping;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.oas.annotations.EnableOpenApi;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.WebMvcRequestHandler;
import springfox.documentation.spring.web.plugins.Docket;

@EnableOpenApi
@Configuration
public class SpringFoxSwaggerConfig {
    @Resource
    OpenApiProperties openApiProperties;

    @Bean
    public ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.openApiProperties.getTitle()).description(this.openApiProperties.getDescription()).termsOfServiceUrl(this.openApiProperties.getServiceUrl()).contact(new Contact(this.openApiProperties.getAuthor(), this.openApiProperties.getContactUrl(), this.openApiProperties.getEmail())).version(this.openApiProperties.getVersion()).build();
    }

    @Bean
    public Docket pc(ApiInfo apiInfo) {
        return this.docket(apiInfo, ApiTypeEnum.PC);
    }

    @Bean
    public Docket app(ApiInfo apiInfo) {
        return this.docket(apiInfo, ApiTypeEnum.APP);
    }

    @Bean
    public Docket feign(ApiInfo apiInfo) {
        return this.docket(apiInfo, ApiTypeEnum.FEIGN);
    }

    @Bean
    public Docket api(ApiInfo apiInfo) {
        return this.docket(apiInfo, ApiTypeEnum.API);
    }

    @Bean
    public Docket inner(ApiInfo apiInfo) {
        return this.docket(apiInfo, ApiTypeEnum.INNER);
    }

    private Docket docket(ApiInfo apiInfo, ApiTypeEnum apiTypeEnum) {
        return new Docket(DocumentationType.OAS_30).enable(this.openApiProperties.isEnable()).apiInfo(apiInfo).groupName(apiTypeEnum.getText()).select().apis(input -> {
            String packageName = ((WebMvcRequestHandler)input).getHandlerMethod().getMethod().getDeclaringClass().getName();
            return packageName.startsWith(this.openApiProperties.getBasePackage()) && packageName.contains("controller." + apiTypeEnum.getCode().toLowerCase());
        }).paths(PathSelectors.any()).build();
    }

    @Bean
    public WebMvcEndpointHandlerMapping webEndpointServletHandlerMapping(WebEndpointsSupplier webEndpointsSupplier, ServletEndpointsSupplier servletEndpointsSupplier, ControllerEndpointsSupplier controllerEndpointsSupplier, EndpointMediaTypes endpointMediaTypes, CorsEndpointProperties corsProperties, WebEndpointProperties webEndpointProperties, Environment environment) {
        ArrayList allEndpoints = new ArrayList();
        Collection webEndpoints = webEndpointsSupplier.getEndpoints();
        allEndpoints.addAll(webEndpoints);
        allEndpoints.addAll(servletEndpointsSupplier.getEndpoints());
        allEndpoints.addAll(controllerEndpointsSupplier.getEndpoints());
        String basePath = webEndpointProperties.getBasePath();
        EndpointMapping endpointMapping = new EndpointMapping(basePath);
        boolean shouldRegisterLinksMapping = this.shouldRegisterLinksMapping(webEndpointProperties, environment, basePath);
        return new WebMvcEndpointHandlerMapping(endpointMapping, webEndpoints, endpointMediaTypes, corsProperties.toCorsConfiguration(), new EndpointLinksResolver(allEndpoints, basePath), shouldRegisterLinksMapping, null);
    }

    private boolean shouldRegisterLinksMapping(WebEndpointProperties webEndpointProperties, Environment environment, String basePath) {
        return webEndpointProperties.getDiscovery().isEnabled() && (StringUtils.hasText((String)basePath) || ManagementPortType.get((Environment)environment).equals((Object)ManagementPortType.DIFFERENT));
    }
}

