package cn.openjava.openapi.starter.properties;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Getter
@Setter
@Component
@ConfigurationProperties(prefix = "openjava.open-api")
public class OpenApiProperties {
    /**
     * 是否开启
     */
    boolean enable = true;
    /**
     * 标题
     */
    private String title = "OpenJava";

    /**
     * 描述
     */
    private String description = "OpenJava 企业级开发平台";

    /**
     * 服务URL
     */
    private String serviceUrl = "https://www.openjava.cn/";

    /**
     * 作者
     */
    private String author = "cn-openjava";

    /**
     * 作者URL
     */
    private String contactUrl = "";

    /**
     * 邮箱地址
     */
    private String email = "";
    /**
     * 版本号
     */
    private String version = "v1.0.0";

    /**
     * 基础包
     */
    private String basePackage = "cn.openjava";
}
