/*
 * Decompiled with CFR 0.152.
 */
package cn.openjava.mybatis.plus.starter.mapper;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import cn.openjava.basic.format.exception.OpenJavaException;
import cn.openjava.basic.format.message.DBMessage;
import cn.openjava.basic.format.message.IMessage;
import cn.openjava.basic.format.message.SystemMessage;
import cn.openjava.basic.format.vo.Form;
import cn.openjava.basic.format.vo.Grid;
import cn.openjava.mybatis.plus.starter.annotation.IsNotDBField;
import cn.openjava.mybatis.plus.starter.annotation.PrimaryKey;
import cn.openjava.mybatis.plus.starter.annotation.QueryCondition;
import cn.openjava.mybatis.plus.starter.utils.ConvertUtil;
import cn.openjava.mybatis.plus.starter.utils.ObjUtil;
import cn.openjava.mybatis.plus.starter.vo.PageVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.annotations.Param;

public interface OpenJavaBaseMapper<T>
extends BaseMapper<T> {
    public static final Log log = LogFactory.getLog(OpenJavaBaseMapper.class);
    public static final String serialVersionUID = "serialVersionUID";
    public static final String sorts = "sorts";

    default public Grid selectPage(long current, long size, @Param(value="ew") Wrapper<T> queryWrapper, Class queryVoClass) {
        if (queryVoClass == null) {
            return ConvertUtil.convertIPage2Grid(this.selectPage((IPage)new Page(current, size), queryWrapper));
        }
        if (queryWrapper instanceof QueryWrapper) {
            Field[] fields = queryVoClass.getDeclaredFields();
            ArrayList<String> columns = new ArrayList<String>();
            for (Field field : fields) {
                if (serialVersionUID.equals(field.getName()) || field.isAnnotationPresent(IsNotDBField.class)) continue;
                columns.add(StrUtil.toUnderlineCase((CharSequence)field.getName()));
            }
            return ConvertUtil.convertIPage2Grid(this.selectPage((IPage)new Page(current, size), queryWrapper), queryVoClass);
        }
        return ConvertUtil.convertIPage2Grid(this.selectPage((IPage)new Page(current, size), queryWrapper), queryVoClass);
    }

    default public Form selectById(Serializable id, Class queryVoClass) {
        Object t = this.selectById(id);
        if (t == null) {
            throw new OpenJavaException((IMessage)DBMessage.QUERY_FAIL_NO_DATA);
        }
        return new Form().beanConvert(t, queryVoClass);
    }

    default public <P extends PageVo> Grid<T> selectPage(P condition) {
        return this.selectPage(condition.getCurrent(), condition.getSize(), (Wrapper<T>)this.condition2Wrapper(condition, null), null);
    }

    default public <P extends PageVo> Grid selectPage(P condition, Class queryVoClass) {
        return this.selectPage(condition.getCurrent(), condition.getSize(), (Wrapper<T>)this.condition2Wrapper(condition, queryVoClass), queryVoClass);
    }

    default public <P extends PageVo> QueryWrapper condition2Wrapper(P condition, Class queryVoClass) {
        QueryWrapper queryWrapper = new QueryWrapper();
        try {
            Field[] voFields;
            if (queryVoClass != null && (voFields = queryVoClass.getFields()) != null) {
                ArrayList<String> args = new ArrayList<String>();
                Field[] fieldArray = voFields;
                int n = fieldArray.length;
                for (int i = 0; i < n; ++i) {
                    Field field = fieldArray[i];
                    if (serialVersionUID.equalsIgnoreCase(field.getName())) continue;
                    args.add(StrUtil.toUnderlineCase((CharSequence)field.getName()));
                }
                queryWrapper = (QueryWrapper)queryWrapper.select((Object[])args.toArray(new String[args.size()]));
            }
            Field[] fields = condition.getClass().getDeclaredFields();
            for (Field field : fields) {
                if (serialVersionUID.equals(field.getName()) || sorts.equals(field.getName())) continue;
                QueryCondition annotation = field.getDeclaredAnnotation(QueryCondition.class);
                Method method = condition.getClass().getDeclaredMethod("get" + StrUtil.upperFirst((CharSequence)(annotation == null || StrUtil.isEmpty((CharSequence)annotation.column()) ? field.getName() : annotation.column())), new Class[0]);
                Object value = method.invoke(condition, new Object[0]);
                if (StrUtil.isEmptyIfStr((Object)value)) {
                    if (annotation == null || annotation.canBeEmpty() || !StrUtil.isEmptyIfStr((Object)value)) continue;
                    throw new OpenJavaException((String)(StrUtil.isNotBlank((CharSequence)annotation.messageForEmpty()) ? annotation.messageForEmpty() : field.getName() + "\u4e0d\u53ef\u4e3a\u7a7a"));
                }
                String columnName = StrUtil.toUnderlineCase((CharSequence)field.getName());
                if (annotation == null) {
                    queryWrapper.eq((Object)columnName, value);
                    continue;
                }
                Method wrapperMethod = queryWrapper.getClass().getMethod(StrUtil.toCamelCase((CharSequence)annotation.type().name().toLowerCase()), Object.class, Object.class);
                wrapperMethod.invoke((Object)queryWrapper, columnName, value);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new OpenJavaException((IMessage)SystemMessage.REFLECT_HANDLER_EXCEPTION);
        }
        if (condition.getSorts() != null) {
            Map sorts = (Map)JSONUtil.toBean((String)condition.getSorts(), Map.class);
            for (Map.Entry entry : sorts.entrySet()) {
                switch (((String)entry.getValue()).toLowerCase()) {
                    case "asc": {
                        queryWrapper.orderByAsc((Object)StrUtil.toUnderlineCase((CharSequence)((CharSequence)entry.getKey())));
                        break;
                    }
                    case "desc": {
                        queryWrapper.orderByDesc((Object)StrUtil.toUnderlineCase((CharSequence)((CharSequence)entry.getKey())));
                    }
                }
            }
        }
        return queryWrapper;
    }

    default public <P> QueryWrapper vo2Wrapper(P deleteVo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        try {
            Field[] fields;
            for (Field field : fields = deleteVo.getClass().getDeclaredFields()) {
                Method method;
                Object value;
                if (serialVersionUID.equals(field.getName()) || StrUtil.isEmptyIfStr((Object)(value = (method = deleteVo.getClass().getDeclaredMethod("get" + StrUtil.upperFirst((CharSequence)field.getName()), new Class[0])).invoke(deleteVo, new Object[0])))) continue;
                String columnName = StrUtil.toUnderlineCase((CharSequence)field.getName());
                queryWrapper.eq((Object)columnName, value);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new OpenJavaException((IMessage)SystemMessage.REFLECT_HANDLER_EXCEPTION);
        }
        return queryWrapper;
    }

    default public String deleteForResult(Serializable id) {
        int i = this.deleteById(id);
        if (i > 0) {
            return DBMessage.DELETE_SUCCESS.message();
        }
        throw new OpenJavaException((IMessage)DBMessage.DELETE_FAIL_NOT_FOUND);
    }

    default public String deleteForResult(Collection<?> idList) {
        if (idList.size() == 0) {
            throw new OpenJavaException((IMessage)DBMessage.DELETE_FAIL_NO_ID);
        }
        int i = this.deleteBatchIds(idList);
        if (i == 0) {
            throw new OpenJavaException((IMessage)DBMessage.DELETE_FAIL_NOT_FOUND);
        }
        if (i == idList.size()) {
            return DBMessage.DELETE_SUCCESS.message();
        }
        throw new OpenJavaException((IMessage)DBMessage.DELETE_SUCCESS_AND_FAIL, new Object[]{idList.size(), i, idList.size() - i});
    }

    default public <P> String deleteByVoForResult(P deleteVo) {
        QueryWrapper wrapper = this.vo2Wrapper(deleteVo);
        if (ObjUtil.isAllFieldsNull(deleteVo)) {
            throw new OpenJavaException((IMessage)DBMessage.DELETE_FAIL_NO_CONDITION);
        }
        int i = this.delete((Wrapper)wrapper);
        if (i > 0) {
            return DBMessage.DELETE_SUCCESS.message();
        }
        throw new OpenJavaException((IMessage)DBMessage.DELETE_FAIL_NOT_FOUND);
    }

    default public <P> String addForResult(P addVo, Class entityClass) {
        if (this.add(addVo, entityClass) > 0) {
            return DBMessage.INSERT_SUCCESS.message();
        }
        throw new OpenJavaException((IMessage)DBMessage.INSERT_FAIL);
    }

    default public <P> String addForResult(P addVo, Class entityClass, String message) {
        if (this.add(addVo, entityClass) > 0) {
            return message;
        }
        throw new OpenJavaException((IMessage)DBMessage.INSERT_FAIL);
    }

    default public <P> String addForResult(T entity) {
        int i = this.insert(entity);
        if (i > 0) {
            return DBMessage.INSERT_SUCCESS.message();
        }
        throw new OpenJavaException((IMessage)DBMessage.INSERT_FAIL);
    }

    default public <P> int add(P addVo, Class entityClass) {
        return this.insert(BeanUtil.toBean(addVo, (Class)entityClass));
    }

    default public <P> String updateForResult(P updateVo, Class entityClass) {
        if (this.update(updateVo, entityClass) > 0) {
            return DBMessage.UPDATE_SUCCESS.message();
        }
        throw new OpenJavaException((IMessage)DBMessage.UPDATE_FAIL);
    }

    default public <P> int update(P updateVo, Class entityClass) {
        return this.updateById(BeanUtil.toBean(updateVo, (Class)entityClass));
    }

    default public <P> Serializable getPkFromVo(P vo) {
        try {
            Field[] fields;
            for (Field field : fields = vo.getClass().getDeclaredFields()) {
                PrimaryKey annotation = field.getDeclaredAnnotation(PrimaryKey.class);
                if (annotation == null) continue;
                Method method = vo.getClass().getDeclaredMethod("get" + StrUtil.upperFirst((CharSequence)field.getName()), new Class[0]);
                return (Serializable)method.invoke(vo, new Object[0]);
            }
            return null;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

