package cn.openjava.mybatis.plus.starter.mapper;


import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import cn.openjava.basic.format.exception.OpenJavaException;
import cn.openjava.basic.format.message.DBMessage;
import cn.openjava.basic.format.message.SystemMessage;
import cn.openjava.basic.format.vo.Form;
import cn.openjava.basic.format.vo.Grid;
import cn.openjava.mybatis.plus.starter.annotation.IsNotDBField;
import cn.openjava.mybatis.plus.starter.annotation.PrimaryKey;
import cn.openjava.mybatis.plus.starter.annotation.QueryCondition;
import cn.openjava.mybatis.plus.starter.utils.ConvertUtil;
import cn.openjava.mybatis.plus.starter.utils.ObjUtil;
import cn.openjava.mybatis.plus.starter.vo.PageVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.annotations.Param;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface OpenJavaBaseMapper<T> extends BaseMapper<T> {
    Log log = LogFactory.getLog(OpenJavaBaseMapper.class);

    String serialVersionUID = "serialVersionUID";

    String sorts = "sorts";

    /**
     * 分页查询
     *
     * @param current      当前页
     * @param size         每页条目数
     * @param queryWrapper 查询条件
     * @return Grid对象
     */
    default Grid selectPage(long current, long size, @Param(Constants.WRAPPER) Wrapper<T> queryWrapper, Class queryVoClass) {
        if (queryVoClass == null) {
            return ConvertUtil.convertIPage2Grid(selectPage(new Page(current, size), queryWrapper));
        } else {
            if (queryWrapper instanceof QueryWrapper) {
                Field[] fields = queryVoClass.getDeclaredFields();
                List<String> columns = new ArrayList<>();
                for (Field field : fields) {
                    if (!serialVersionUID.equals(field.getName()) && !field.isAnnotationPresent(IsNotDBField.class)) {
                        columns.add(StrUtil.toUnderlineCase(field.getName()));
                    }
                }
                //todo:修改完善
//                QueryWrapper queryWrapper1 = ((QueryWrapper) queryWrapper);
//                queryWrapper1.select(columns.toArray(new String[0]), queryVoClass);
                return ConvertUtil.convertIPage2Grid(selectPage(new Page(current, size), queryWrapper), queryVoClass);
            } else {
                //todo:优化 LambdaQueryWrapper
                return ConvertUtil.convertIPage2Grid(selectPage(new Page(current, size), queryWrapper), queryVoClass);
            }

        }
    }

    default Form selectById(Serializable id, Class queryVoClass) {
        //todo:优化，去掉不需要查询的字段
        T t = selectById(id);
        if (t == null) {
            throw new OpenJavaException(DBMessage.QUERY_FAIL_NO_DATA);
        } else {
            return new Form().beanConvert(t, queryVoClass);
        }
    }

    /**
     * 分页查询
     *
     * @param condition 继承了PageVo的对象
     * @return 分页结果
     */
    default <P extends PageVo> Grid<T> selectPage(P condition) {
        return selectPage(condition.getCurrent(), condition.getSize(), condition2Wrapper(condition, null), null);
    }

    /**
     * 分页查询
     *
     * @param condition    继承了PageVo的对象
     * @param queryVoClass 查询VO
     * @param <P>
     * @return
     */
    default <P extends PageVo> Grid selectPage(P condition, Class queryVoClass) {
        return selectPage(condition.getCurrent(), condition.getSize(), condition2Wrapper(condition, queryVoClass), queryVoClass);
    }

    /**
     * condition转queryWrapper对象
     *
     * @param condition 条件VO
     * @param <P>       任意对象
     * @return 分页结果
     */
    default <P extends PageVo> QueryWrapper condition2Wrapper(P condition, Class queryVoClass) {
        QueryWrapper<P> queryWrapper = new QueryWrapper<>();
        try {
            if (queryVoClass != null) {
                Field[] voFields = queryVoClass.getFields();
                if (voFields != null) {
                    List<String> args = new ArrayList();
                    for (Field field : voFields) {
                        //排除序列化参数
                        if (!this.serialVersionUID.equalsIgnoreCase(field.getName())) {
                            args.add(StrUtil.toUnderlineCase(field.getName()));
                        }
                    }
                    queryWrapper = queryWrapper.select(args.toArray(new String[args.size()]));
                }
            }
            Field[] fields = condition.getClass().getDeclaredFields();
            for (Field field : fields) {
                if (serialVersionUID.equals(field.getName()) || sorts.equals(field.getName())) {
                    continue;
                }
                QueryCondition annotation = field.getDeclaredAnnotation(QueryCondition.class);
                Method method = condition.getClass().getDeclaredMethod("get" + StrUtil.upperFirst(annotation == null || StrUtil.isEmpty(annotation.column()) ? field.getName() : annotation.column()));
                Object value = method.invoke(condition);
                if (StrUtil.isEmptyIfStr(value)) {
                    //当值为空，注解标记不为空时（canBeEmpty=false），抛出异常
                    if (annotation != null && !annotation.canBeEmpty() && StrUtil.isEmptyIfStr(value)) {
                        throw new OpenJavaException(StrUtil.isNotBlank(annotation.messageForEmpty()) ? annotation.messageForEmpty() : (field.getName() + "不可为空"));
                    }
                    continue;
                }
                String columnName = StrUtil.toUnderlineCase(field.getName());
                if (annotation == null) {
                    queryWrapper.eq(columnName, value);
                } else {
                    Method wrapperMethod = queryWrapper.getClass().getMethod(StrUtil.toCamelCase(annotation.type().name().toLowerCase()), Object.class, Object.class);
                    wrapperMethod.invoke(queryWrapper, columnName, value);
                }
            }
        } catch (NoSuchMethodException | InvocationTargetException | IllegalAccessException e) {
            log.error(e.getMessage(), e);
            throw new OpenJavaException(SystemMessage.REFLECT_HANDLER_EXCEPTION);
        }
        //排序
        if (condition.getSorts() != null) {
            Map<String, String> sorts = JSONUtil.toBean(condition.getSorts(), Map.class);
            for (Map.Entry<String, String> entry : sorts.entrySet()) {
                switch (entry.getValue().toLowerCase()) {
                    case "asc":
                        queryWrapper.orderByAsc(StrUtil.toUnderlineCase(entry.getKey()));
                        break;
                    case "desc":
                        queryWrapper.orderByDesc(StrUtil.toUnderlineCase(entry.getKey()));
                        break;
                }
            }
        }
        return queryWrapper;
    }

    /**
     * condition转queryWrapper对象
     *
     * @param deleteVo 条件VO
     * @param <P>      任意对象
     * @return 分页结果
     */
    default <P> QueryWrapper vo2Wrapper(P deleteVo) {
        QueryWrapper<P> queryWrapper = new QueryWrapper<>();
        try {
            Field[] fields = deleteVo.getClass().getDeclaredFields();
            for (Field field : fields) {
                if (this.serialVersionUID.equals(field.getName())) {
                    continue;
                }
                Method method = deleteVo.getClass().getDeclaredMethod("get" + StrUtil.upperFirst(field.getName()));
                Object value = method.invoke(deleteVo);
                if (StrUtil.isEmptyIfStr(value)) {
                    continue;
                }
                String columnName = StrUtil.toUnderlineCase(field.getName());
                queryWrapper.eq(columnName, value);
            }
        } catch (NoSuchMethodException | InvocationTargetException | IllegalAccessException e) {
            log.error(e.getMessage(), e);
            throw new OpenJavaException(SystemMessage.REFLECT_HANDLER_EXCEPTION);
        }
        return queryWrapper;
    }

    /**
     * 根据ID进行删除
     *
     * @param id
     * @return
     */
    default String deleteForResult(Serializable id) {
        int i = deleteById(id);
        if (i > 0) {
            return DBMessage.DELETE_SUCCESS.message();
        } else {
            throw new OpenJavaException(DBMessage.DELETE_FAIL_NOT_FOUND);
        }
    }

    /**
     * 批量删除
     *
     * @param idList
     * @return
     */
    default String deleteForResult(Collection<?> idList) {
        if (idList.size() == 0) {
            throw new OpenJavaException(DBMessage.DELETE_FAIL_NO_ID);
        }
        int i = deleteBatchIds(idList);
        if (i == 0) {
            throw new OpenJavaException(DBMessage.DELETE_FAIL_NOT_FOUND);
        } else if (i == idList.size()) {
            return DBMessage.DELETE_SUCCESS.message();
        } else {
            throw new OpenJavaException(DBMessage.DELETE_SUCCESS_AND_FAIL, idList.size(), i, idList.size() - i);
        }
    }

    /**
     * 删除
     *
     * @param deleteVo 删除VO
     * @param <P>
     * @return
     */
    default <P> String deleteByVoForResult(P deleteVo) {
        QueryWrapper wrapper = vo2Wrapper(deleteVo);
        if (ObjUtil.isAllFieldsNull(deleteVo)) {
            throw new OpenJavaException(DBMessage.DELETE_FAIL_NO_CONDITION);
        }
        int i = delete(wrapper);
        if (i > 0) {
            return DBMessage.DELETE_SUCCESS.message();
        } else {
            throw new OpenJavaException(DBMessage.DELETE_FAIL_NOT_FOUND);
        }
    }

    /**
     * 新增
     *
     * @param addVo       新增Vo对象
     * @param entityClass 实体类对象
     * @param <P>
     * @return 是或者否
     */
    default <P> String addForResult(P addVo, Class entityClass) {
        if (add(addVo, entityClass) > 0) {
            return DBMessage.INSERT_SUCCESS.message();
        } else {
            throw new OpenJavaException(DBMessage.INSERT_FAIL);
        }
    }

    default <P> String addForResult(P addVo, Class entityClass, String message) {
        if (add(addVo, entityClass) > 0) {
            return message;
        } else {
            throw new OpenJavaException(DBMessage.INSERT_FAIL);
        }
    }

    /**
     * 增加
     *
     * @param entity 实体类
     * @param <P>
     * @return 成功标志
     */
    default <P> String addForResult(T entity) {
        int i = insert(entity);
        if (i > 0) {
            return DBMessage.INSERT_SUCCESS.message();
        } else {
            throw new OpenJavaException(DBMessage.INSERT_FAIL);
        }
    }

    /**
     * 新增
     *
     * @param addVo       新增Vo对象
     * @param entityClass 实体类对象
     * @param <P>
     * @return 是或者否
     */
    default <P> int add(P addVo, Class entityClass) {
        return insert((T) BeanUtil.toBean(addVo, entityClass));
    }

    /**
     * 修改
     *
     * @param updateVo    修改Vo
     * @param entityClass
     * @param <P>
     * @return
     */
    default <P> String updateForResult(P updateVo, Class entityClass) {
        if (update(updateVo, entityClass) > 0) {
            return DBMessage.UPDATE_SUCCESS.message();
        } else {
            throw new OpenJavaException(DBMessage.UPDATE_FAIL);
        }
    }

    /**
     * 修改
     *
     * @param updateVo    修改Vo
     * @param entityClass
     * @param <P>
     * @return
     */
    default <P> int update(P updateVo, Class entityClass) {
        return updateById((T) BeanUtil.toBean(updateVo, entityClass));
    }

    /**
     * 获取主键值
     *
     * @param vo
     * @param <P>
     * @return
     */
    default <P> Serializable getPkFromVo(P vo) {
        try {
            Field[] fields = vo.getClass().getDeclaredFields();
            for (Field field : fields) {
                PrimaryKey annotation = field.getDeclaredAnnotation(PrimaryKey.class);
                if (annotation != null) {
                    Method method = vo.getClass().getDeclaredMethod("get" + StrUtil.upperFirst(field.getName()));
                    return (Serializable) method.invoke(vo);
                }
            }
            return null;
        } catch (NoSuchMethodException | IllegalAccessException | InvocationTargetException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }
}
