package cn.openjava.mybatis.plus.starter.annotation;

import cn.openjava.mybatis.plus.starter.enums.ConditionType;

import java.lang.annotation.*;

/**
 * 查询条件-加在condition的属性之上
 */
@Documented
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface QueryCondition {
    /**
     * 查询类型
     *
     * @return
     */
    ConditionType type() default ConditionType.EQ;

    /**
     * 对应列
     *
     * @return
     */
    String column() default "";

    /**
     * 是否可为空
     *
     * @return
     */
    boolean canBeEmpty() default true;

    /**
     * 当为空时的提示信息
     *
     * @return
     */
    String messageForEmpty() default "";
}
