package cn.openjava.basic.format.message;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.experimental.Accessors;

@Getter
@Accessors(fluent = true)
@AllArgsConstructor
public enum DBMessage implements IMessage {
    /**
     * 成功
     */
    INSERT_SUCCESS(MessageType.SUCCESS, 201, "新增成功"),
    DELETE_SUCCESS(MessageType.SUCCESS, 202, "删除成功"),
    UPDATE_SUCCESS(MessageType.SUCCESS, 203, "修改成功"),
    QUERY_SUCCESS(MessageType.SUCCESS, 204, "查询成功"),
    /**
     * 失败
     */
    DELETE_FAIL_NOT_FOUND(MessageType.WARNING, 202, "删除失败，数据不存在"),
    /**
     * 失败
     */
    DELETE_FAIL_EXCEPTION(MessageType.ERROR, 203, "删除失败，发生异常"),
    /**
     * 失败
     */
    DELETE_FAIL_NO_CONDITION(MessageType.WARNING, 204, "删除失败，不允许不加条件进行删除"),

    /**
     * 部分失败
     */
    DELETE_SUCCESS_AND_FAIL(MessageType.WARNING, 202, "共有{0}条数据，成功{1}条，失败{2}条"),

    /**
     * 失败
     */
    INSERT_FAIL(MessageType.WARNING, 205, "新增失败"),
    /**
     * 失败
     */
    INSERT_FAIL_EXCEPTION(MessageType.ERROR, 207, "新增失败，发生异常"),
    /**
     * 失败
     */
    UPDATE_FAIL(MessageType.WARNING, 208, "修改失败，数据不存在"),
    /**
     * 失败
     */
    UPDATE_FAIL_EXCEPTION(MessageType.WARNING, 205, "修改失败，发生异常"),
    /**
     * 查询失败-无数据
     */
    QUERY_FAIL_NO_DATA(MessageType.WARNING, 208, "查询失败，无此数据"),
    /**
     * 删除失败
     */
    DELETE_FAIL_NO_ID(MessageType.WARNING, 208, "删除失败，未传入ID");
    /**
     * 类型
     */
    private MessageType type;
    /**
     * 消息编码
     */
    private int code;
    /**
     * 消息内容
     */
    private String message;
}
