/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.framework.tools.vo;

import cn.opencodes.framework.tools.utils.StringUtils;
import cn.opencodes.framework.tools.xss.SQLFilter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class Query
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private int currPage = 1;
    private int pageSize = 10;
    private String orderBy;

    public Query(Object ... objs) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (objs != null) {
            for (int i = 0; i < objs.length; i += 2) {
                params.put(objs[i].toString(), objs[i + 1]);
            }
            this.processForMap(params);
        }
    }

    public Query(Map<String, Object> params) {
        this.processForMap(params);
    }

    private void processForMap(Map<String, Object> params) {
        if (params == null || params.size() < 1) {
            return;
        }
        for (Map.Entry<String, Object> e : params.entrySet()) {
            if (e.getValue() != null && e.getValue() instanceof String) {
                this.put(e.getKey(), (Object)e.getValue().toString().trim());
                continue;
            }
            this.put(e.getKey(), e.getValue());
        }
        this.currPage = this.getInt(params.get("currPage"), this.currPage);
        this.pageSize = this.getInt(params.get("pageSize"), this.pageSize);
        this.orderBy = (String)params.get("orderBy");
        this.put("pageStart", (Object)((this.currPage - 1) * this.pageSize));
        this.put("pageSize", (Object)this.pageSize);
        if (StringUtils.isNotBlank((String)this.orderBy)) {
            this.orderBy = SQLFilter.sqlInject(this.orderBy);
            this.put("orderBy", (Object)this.orderBy);
        } else {
            this.orderBy = null;
        }
    }

    @Override
    public Query put(String key, Object value) {
        if (key.equals("orderBy") && value != null && StringUtils.isNotBlank((String)value.toString())) {
            value = SQLFilter.sqlInject(value.toString());
        }
        super.put(key, value);
        return this;
    }

    public int getCurrPage() {
        return this.currPage;
    }

    public void setCurrPage(int currPage) {
        this.currPage = currPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    private int getInt(Object param, int defalut) {
        int v = defalut;
        try {
            if (param != null) {
                v = Integer.parseInt(param.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }
}

