/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.framework.tools.utils;

import cn.opencodes.framework.tools.utils.StringUtils;
import cn.opencodes.framework.tools.vo.RException;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;

public final class ValidatorUtils {
    private static Validator validator = Validation.buildDefaultValidatorFactory().getValidator();

    public static void validateEntity(Object object, Class<?> ... groups) {
        Set constraintViolations = validator.validate(object, (Class[])groups);
        if (!constraintViolations.isEmpty()) {
            StringBuilder msg = new StringBuilder();
            for (ConstraintViolation constraint : constraintViolations) {
                msg.append(constraint.getMessage()).append("<br>");
            }
            throw new RException(msg.toString(), -1);
        }
    }

    public static void validateEntitys(List<?> list, Class<?> ... groups) {
        if (list == null || list.size() < 1) {
            throw new RException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", -1);
        }
        for (Object obj : list) {
            ValidatorUtils.validateEntity(obj, groups);
        }
    }

    public static void isNullOrZero(Object obj, String message) {
        if (obj == null) {
            throw new RException(message, -1);
        }
        if (obj instanceof String && StringUtils.isBlank((String)obj.toString())) {
            throw new RException(message, -1);
        }
        if (obj instanceof String[] && ((String[])obj).length == 0) {
            throw new RException(message, -1);
        }
        if (obj instanceof Long && (Long)obj == 0L) {
            throw new RException(message, -1);
        }
        if (obj instanceof Long[] && ((Long[])obj).length == 0) {
            throw new RException(message, -1);
        }
        if (obj instanceof Integer && (Integer)obj == 0) {
            throw new RException(message, -1);
        }
        if (obj instanceof Integer[] && ((Integer[])obj).length == 0) {
            throw new RException(message, -1);
        }
        if (obj instanceof Double && (Double)obj == 0.0) {
            throw new RException(message, -1);
        }
        if (obj instanceof Double[] && ((Double[])obj).length == 0) {
            throw new RException(message, -1);
        }
    }

    public static void isNullOrZero(Object object) {
        String message = "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a";
        ValidatorUtils.isNullOrZero(object, message);
    }
}

