/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.framework.tools.mail;

import cn.opencodes.framework.tools.mail.EmailSenderConfig;
import cn.opencodes.framework.tools.mail.MailRecipientUtils;
import cn.opencodes.framework.tools.mail.MailSenderUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;

public class EmailManager {
    private EmailSenderConfig esc;

    public EmailManager(EmailSenderConfig esConfig) {
        this.esc = esConfig;
    }

    public static EmailManager getInstance(String ... params) {
        String charSet = "UTF-8";
        String userName = null;
        String password = null;
        String host = null;
        String from = null;
        String fromNick = null;
        String smtpPort = null;
        for (int i = 0; i < params.length; ++i) {
            if (i == 0) {
                userName = params[0];
                continue;
            }
            if (i == 1) {
                password = params[1];
                continue;
            }
            if (i == 2) {
                host = params[2];
                continue;
            }
            if (i == 3) {
                from = params[3];
                continue;
            }
            if (i == 4) {
                fromNick = params[4];
                continue;
            }
            if (i == 5) {
                smtpPort = params[5];
                continue;
            }
            if (i != 6) continue;
            charSet = params[6];
        }
        return new EmailManager(new EmailSenderConfig(from, fromNick, userName, password, charSet, host, smtpPort));
    }

    public void send(String toMail, String csMail, String subject, String message) throws AddressException, MessagingException, UnsupportedEncodingException {
        MailSenderUtils.send(toMail, csMail, subject, message, this.esc.getUsername(), this.esc.getPassword(), this.esc.getHost(), this.esc.getSmtpPort(), this.esc.getFromNick(), this.esc.getCharSet());
    }

    public void send(String toMail, String subject, String message) throws AddressException, UnsupportedEncodingException, MessagingException {
        this.send(toMail, null, subject, message);
    }

    public void sendForFile(String toMail, String csMail, String subject, String message, String[] files) throws AddressException, MessagingException, UnsupportedEncodingException {
        MailSenderUtils.sendForFile(toMail, csMail, subject, message, files, this.esc.getUsername(), this.esc.getPassword(), this.esc.getHost(), this.esc.getSmtpPort(), this.esc.getFromNick(), this.esc.getCharSet());
    }

    public void sendForFile(String toMail, String subject, String message, String[] files) throws AddressException, UnsupportedEncodingException, MessagingException {
        this.sendForFile(toMail, null, subject, message, files);
    }

    public void recipient() throws MessagingException, IOException {
        MailRecipientUtils.recipient(this.esc.getUsername(), this.esc.getPassword(), this.esc.getHost().replace("smtp", "pop3"), 110);
    }

    public void recipient(String host, int port) throws MessagingException, IOException {
        MailRecipientUtils.recipient(this.esc.getUsername(), this.esc.getPassword(), host, port);
    }

    public void recipient(String username, String password) throws MessagingException, IOException {
        MailRecipientUtils.recipient(username, password, this.esc.getHost().replace("smtp", "pop3"), 110);
    }

    public void recipient(String username, String password, String host) throws MessagingException, IOException {
        MailRecipientUtils.recipient(username, password, host, 110);
    }

    public void recipient(String username, String password, String host, int port) throws MessagingException, IOException {
        MailRecipientUtils.recipient(username, password, host, port);
    }
}

