/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.framework.tools.db;

import cn.opencodes.framework.tools.db.DbConfig;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JdbcHelper {
    private static ThreadLocal<DbConfig> db = new ThreadLocal();

    public static void setDbConfig(DbConfig dbCfg) {
        db.set(dbCfg);
    }

    public static List query(String sql) throws SQLException {
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = db.get().getPreparedStatement(sql);
            rs = preparedStatement.executeQuery();
            List<Map<String, Object>> list = JdbcHelper.ResultToListMap(rs);
            db.get().freePrep(rs);
            return list;
        }
        catch (SQLException e) {
            try {
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                db.get().freePrep(rs);
                throw throwable;
            }
        }
    }

    public static List<Map<String, Object>> query(String sql, Object ... paramters) throws SQLException {
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = db.get().getPreparedStatement(sql);
            for (int i = 0; i < paramters.length; ++i) {
                preparedStatement.setObject(i + 1, paramters[i]);
            }
            rs = preparedStatement.executeQuery();
            List<Map<String, Object>> list = JdbcHelper.ResultToListMap(rs);
            db.get().freePrep(rs);
            return list;
        }
        catch (SQLException e) {
            try {
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                db.get().freePrep(rs);
                throw throwable;
            }
        }
    }

    public static Object getSingle(String sql) throws SQLException {
        Object result = null;
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = db.get().getPreparedStatement(sql);
            rs = preparedStatement.executeQuery();
            if (rs.next()) {
                result = rs.getObject(1);
            }
            Object object = result;
            db.get().freePrep(rs);
            return object;
        }
        catch (SQLException e) {
            try {
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                db.get().freePrep(rs);
                throw throwable;
            }
        }
    }

    public static Object getSingle(String sql, Object ... paramters) throws SQLException {
        Object result = null;
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = db.get().getPreparedStatement(sql);
            for (int i = 0; i < paramters.length; ++i) {
                preparedStatement.setObject(i + 1, paramters[i]);
            }
            rs = preparedStatement.executeQuery();
            if (rs.next()) {
                result = rs.getObject(1);
            }
            Object object = result;
            db.get().freePrep(rs);
            return object;
        }
        catch (SQLException e) {
            try {
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                db.get().freePrep(rs);
                throw throwable;
            }
        }
    }

    public static int update(String sql) throws SQLException {
        try {
            PreparedStatement preparedStatement = db.get().getPreparedStatement(sql);
            int n = preparedStatement.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException(e);
        }
        finally {
            db.get().freePrep(null);
        }
    }

    public static int update(String sql, Object ... paramters) throws SQLException {
        try {
            PreparedStatement preparedStatement = db.get().getPreparedStatement(sql);
            for (int i = 0; i < paramters.length; ++i) {
                preparedStatement.setObject(i + 1, paramters[i]);
            }
            int n = preparedStatement.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException(e);
        }
        finally {
            db.get().freePrep(null);
        }
    }

    public static Object insertWithReturnPrimeKey(String sql) throws SQLException {
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        Object result = null;
        try {
            conn = db.get().getConnection();
            preparedStatement = conn.prepareStatement(sql, 1);
            preparedStatement.execute();
            rs = preparedStatement.getGeneratedKeys();
            if (rs.next()) {
                result = rs.getObject(1);
            }
            Object object = result;
            db.get().free(conn, preparedStatement, rs);
            return object;
        }
        catch (SQLException e) {
            try {
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                db.get().free(conn, preparedStatement, rs);
                throw throwable;
            }
        }
    }

    public static Object insertWithReturnPrimeKey(String sql, Object ... paramters) throws SQLException {
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        Object result = null;
        try {
            conn = db.get().getConnection();
            preparedStatement = conn.prepareStatement(sql, 1);
            for (int i = 0; i < paramters.length; ++i) {
                preparedStatement.setObject(i + 1, paramters[i]);
            }
            preparedStatement.execute();
            rs = preparedStatement.getGeneratedKeys();
            if (rs.next()) {
                result = rs.getObject(1);
            }
            Object i = result;
            db.get().free(conn, preparedStatement, rs);
            return i;
        }
        catch (SQLException e) {
            try {
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                db.get().free(conn, preparedStatement, rs);
                throw throwable;
            }
        }
    }

    public static List callableQuery(String procedureSql) throws SQLException {
        ResultSet rs = null;
        try {
            CallableStatement callableStatement = db.get().getCallableStatement(procedureSql);
            rs = callableStatement.executeQuery();
            List<Map<String, Object>> list = JdbcHelper.ResultToListMap(rs);
            db.get().freepCall(rs);
            return list;
        }
        catch (SQLException e) {
            try {
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                db.get().freepCall(rs);
                throw throwable;
            }
        }
    }

    public static List callableQuery(String procedureSql, Object ... paramters) throws SQLException {
        ResultSet rs = null;
        try {
            CallableStatement callableStatement = db.get().getCallableStatement(procedureSql);
            for (int i = 0; i < paramters.length; ++i) {
                callableStatement.setObject(i + 1, paramters[i]);
            }
            rs = callableStatement.executeQuery();
            List<Map<String, Object>> list = JdbcHelper.ResultToListMap(rs);
            db.get().freepCall(rs);
            return list;
        }
        catch (SQLException e) {
            try {
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                db.get().freepCall(rs);
                throw throwable;
            }
        }
    }

    public static Object callableGetSingle(String procedureSql) throws SQLException {
        Object result = null;
        ResultSet rs = null;
        try {
            CallableStatement callableStatement = db.get().getCallableStatement(procedureSql);
            rs = callableStatement.executeQuery();
            while (rs.next()) {
                result = rs.getObject(1);
            }
            Object object = result;
            db.get().freepCall(rs);
            return object;
        }
        catch (SQLException e) {
            try {
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                db.get().freepCall(rs);
                throw throwable;
            }
        }
    }

    public static Object callableGetSingle(String procedureSql, Object ... paramters) throws SQLException {
        Object result = null;
        ResultSet rs = null;
        try {
            CallableStatement callableStatement = db.get().getCallableStatement(procedureSql);
            for (int i = 0; i < paramters.length; ++i) {
                callableStatement.setObject(i + 1, paramters[i]);
            }
            rs = callableStatement.executeQuery();
            while (rs.next()) {
                result = rs.getObject(1);
            }
            Object object = result;
            db.get().freepCall(rs);
            return object;
        }
        catch (SQLException e) {
            try {
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                db.get().freepCall(rs);
                throw throwable;
            }
        }
    }

    public static Object callableWithParamters(String procedureSql) throws SQLException {
        try {
            CallableStatement callableStatement = db.get().getCallableStatement(procedureSql);
            callableStatement.registerOutParameter(0, 1111);
            callableStatement.execute();
            Object object = callableStatement.getObject(0);
            return object;
        }
        catch (SQLException e) {
            throw new SQLException(e);
        }
        finally {
            db.get().freepCall(null);
        }
    }

    public static int callableUpdate(String procedureSql) throws SQLException {
        try {
            CallableStatement callableStatement = db.get().getCallableStatement(procedureSql);
            int n = callableStatement.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException(e);
        }
        finally {
            db.get().freepCall(null);
        }
    }

    public static int callableUpdate(String procedureSql, Object ... parameters) throws SQLException {
        try {
            CallableStatement callableStatement = db.get().getCallableStatement(procedureSql);
            for (int i = 0; i < parameters.length; ++i) {
                callableStatement.setObject(i + 1, parameters[i]);
            }
            int n = callableStatement.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException(e);
        }
        finally {
            db.get().freepCall(null);
        }
    }

    public static int[] batchUpdate(List<String> sqlList) {
        int[] result = new int[]{};
        Connection conn = null;
        Statement statenent = null;
        try {
            conn = db.get().getConnection();
            conn.setAutoCommit(false);
            statenent = conn.createStatement();
            for (String sql : sqlList) {
                statenent.addBatch(sql);
            }
            result = statenent.executeBatch();
            conn.commit();
            db.get().free(conn, statenent, null);
        }
        catch (SQLException e) {
            try {
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    throw new ExceptionInInitializerError(e1);
                }
                throw new ExceptionInInitializerError(e);
            }
            catch (Throwable throwable) {
                db.get().free(conn, statenent, null);
                throw throwable;
            }
        }
        return result;
    }

    private static List<Map<String, Object>> ResultToListMap(ResultSet rs) throws SQLException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        while (rs.next()) {
            ResultSetMetaData md = rs.getMetaData();
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int i = 1; i <= md.getColumnCount(); ++i) {
                map.put(md.getColumnLabel(i), rs.getObject(i));
            }
            list.add(map);
        }
        return list;
    }
}

