/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.framework.tools.db;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DbConfig {
    private String driver;
    private String url;
    private String userName;
    private String password;
    private Connection conn;
    private PreparedStatement preparedStatement;
    private CallableStatement callableStatement;

    public DbConfig() {
    }

    public DbConfig(String driver, String url, String userName, String password) {
        this.driver = driver;
        this.url = url;
        this.userName = userName;
        this.password = password;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Connection getConnection() {
        if (this.conn != null) {
            return this.conn;
        }
        try {
            Class.forName(this.driver);
            this.conn = DriverManager.getConnection(this.url, this.userName, this.password);
        }
        catch (Exception e) {
            throw new RuntimeException("\u521b\u5efa Connection \u53d1\u751f\u5f02\u5e38", e);
        }
        return this.conn;
    }

    public PreparedStatement getPreparedStatement(String sql) {
        if (this.preparedStatement != null) {
            return this.preparedStatement;
        }
        try {
            this.preparedStatement = this.getConnection().prepareStatement(sql);
        }
        catch (Exception e) {
            throw new RuntimeException("\u521b\u5efa PreparedStatement \u53d1\u751f\u5f02\u5e38", e);
        }
        return this.preparedStatement;
    }

    public CallableStatement getCallableStatement(String procedureSql) {
        if (this.callableStatement != null) {
            return this.callableStatement;
        }
        try {
            this.callableStatement = this.getConnection().prepareCall(procedureSql);
        }
        catch (Exception e) {
            throw new RuntimeException("\u521b\u5efa callableStatement \u53d1\u751f\u5f02\u5e38", e);
        }
        return this.callableStatement;
    }

    private void freeConnection(Connection conn) {
        try {
            conn.close();
        }
        catch (SQLException e) {
            throw new RuntimeException("\u5173\u95ed Connection \u53d1\u751f\u5f02\u5e38", e);
        }
    }

    private void freeStatement(Statement statement) {
        try {
            statement.close();
        }
        catch (SQLException e) {
            throw new RuntimeException("\u5173\u95ed Statement \u53d1\u751f\u5f02\u5e38", e);
        }
    }

    private void freeResultSet(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException e) {
            throw new RuntimeException("\u5173\u95ed ResultSet \u53d1\u751f\u5f02\u5e38", e);
        }
    }

    public void freePrep(ResultSet rs) {
        this.free(this.conn, this.preparedStatement, rs);
    }

    public void freepCall(ResultSet rs) {
        this.free(this.conn, this.callableStatement, rs);
    }

    public void free(Connection conn, Statement statement, ResultSet rs) {
        if (rs != null) {
            this.freeResultSet(rs);
        }
        if (statement != null) {
            this.freeStatement(statement);
        }
        if (conn != null) {
            this.freeConnection(conn);
        }
        rs = null;
        this.preparedStatement = null;
        this.callableStatement = null;
        this.conn = null;
    }
}

