/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.framework.core.utils;

import cn.opencodes.framework.core.vo.UserAgent;
import cn.opencodes.framework.core.vo.UserRoot;
import cn.opencodes.framework.tools.utils.JsonUtils;
import cn.opencodes.framework.tools.utils.StringUtils;
import cn.opencodes.framework.tools.utils.UserAgentUtil;
import cn.opencodes.framework.tools.vo.R;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class WebUtils
extends org.apache.shiro.web.util.WebUtils {
    private static final Logger logger = LoggerFactory.getLogger(WebUtils.class);
    private static final String USER_KEY = "al_currentuser";

    public static UserAgent analyticUserAgent(HttpServletRequest request) {
        String userAgent = request.getHeader("user-agent");
        return UserAgentUtil.analyticUserAgent(userAgent);
    }

    public static HttpServletRequest getHttpServletRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public static Object getAttribute(String name) {
        return WebUtils.getHttpServletRequest().getAttribute(name);
    }

    public static void setAttribute(String userKey, Object obj) {
        WebUtils.getHttpServletRequest().setAttribute(userKey, obj);
    }

    public static String getRealPath() {
        return WebUtils.getHttpServletRequest().getServletContext().getRealPath("/");
    }

    public static String getContextPath() {
        return WebUtils.getHttpServletRequest().getServletContext().getContextPath();
    }

    public static void write(HttpServletResponse response, Object o) throws Exception {
        response.setContentType("text/html;charset=utf-8");
        PrintWriter out = response.getWriter();
        out.println(o.toString());
        out.flush();
        out.close();
    }

    public static void write(ServletResponse response, int code, String msg) {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.setContentType("application/json;charset=utf-8");
        try {
            String json = JsonUtils.toJson(R.error(code, msg));
            httpResponse.getWriter().print(json);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public static void write(ServletResponse response, R<?> r) {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.setContentType("application/json;charset=utf-8");
        try {
            String json = JsonUtils.toJson(r);
            httpResponse.getWriter().print(json);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public static void setUser(UserRoot user) {
        WebUtils.setAttribute(USER_KEY, user);
    }

    public static UserRoot getUser() {
        UserRoot user = (UserRoot)WebUtils.getAttribute(USER_KEY);
        if (user == null) {
            user = new UserRoot();
            String appKey = WebUtils.getRequestAppKey((ServletRequest)WebUtils.getHttpServletRequest());
            if (StringUtils.isNotBlank((String)appKey)) {
                user.setUsername(appKey);
            } else {
                user.setUsername(WebUtils.getIpAddr());
            }
        }
        return user;
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = null;
        try {
            ip = request.getHeader("x-forwarded-for");
            if (StringUtils.isEmpty((String)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("Proxy-Client-IP");
            }
            if (StringUtils.isEmpty((String)ip) || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("WL-Proxy-Client-IP");
            }
            if (StringUtils.isEmpty((String)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("HTTP_CLIENT_IP");
            }
            if (StringUtils.isEmpty((String)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("HTTP_X_FORWARDED_FOR");
            }
            if (StringUtils.isEmpty((String)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getRemoteAddr();
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5ba2\u6237\u7aefIP\u5f02\u5e38\uff1a ", (Throwable)e);
        }
        return ip;
    }

    public static String getIpAddr() {
        HttpServletRequest request = WebUtils.getHttpServletRequest();
        return WebUtils.getIpAddr(request);
    }

    public static Map<String, Object> extractToMap(HttpServletRequest request) {
        Map properties = request.getParameterMap();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        Iterator entries = properties.entrySet().iterator();
        String name = null;
        String value = null;
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            name = (String)entry.getKey();
            value = (String)entry.getValue();
            if (value == null) continue;
            if (value instanceof String[]) {
                String[] values = (String[])value;
                StringBuilder vs = new StringBuilder();
                for (int i = 0; i < values.length; ++i) {
                    vs.append(values[i]).append(",");
                }
                vs.deleteCharAt(vs.length() - 1);
                value = vs.toString();
            }
            returnMap.put(name, value);
        }
        return returnMap;
    }

    public static boolean isAjax(HttpServletRequest request) {
        String type;
        String string = type = request.getHeader("X-Requested-With") == null ? "" : request.getHeader("X-Requested-With");
        return type.equals("XMLHttpRequest");
    }

    public static String getRequestAppKey(ServletRequest request) {
        HttpServletRequest httpRequest = WebUtils.toHttp((ServletRequest)request);
        String token = httpRequest.getHeader("appKey");
        if (StringUtils.isBlank((String)token)) {
            token = httpRequest.getParameter("appKey");
        }
        return token;
    }

    public static String getRequestAppSecret(ServletRequest request) {
        HttpServletRequest httpRequest = WebUtils.toHttp((ServletRequest)request);
        String token = httpRequest.getHeader("appSecret");
        if (StringUtils.isBlank((String)token)) {
            token = httpRequest.getParameter("appSecret");
        }
        return token;
    }

    public static String getRequestToken(ServletRequest request) {
        HttpServletRequest httpRequest = WebUtils.toHttp((ServletRequest)request);
        String token = httpRequest.getHeader("token");
        if (StringUtils.isBlank((String)token)) {
            token = httpRequest.getParameter("token");
        }
        return token;
    }
}

