/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.framework.core.shiro;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtTokenGen {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String HEADER = "token";
    protected static final String HEADER_APP_KEY = "appKey";
    protected static final String HEADER_SECRET_KEY = "appSecret";
    private String secret;
    private long expire;

    public String generateToken(Long userId) {
        Date nowDate = new Date();
        Date expireDate = new Date(nowDate.getTime() + this.expire * 1000L);
        return Jwts.builder().setHeaderParam("type", (Object)"JWT").setSubject(userId.toString()).setIssuedAt(nowDate).setExpiration(expireDate).signWith(SignatureAlgorithm.HS512, this.secret).compact();
    }

    public Claims getClaimByToken(String token) {
        try {
            return (Claims)Jwts.parser().setSigningKey(this.secret).parseClaimsJws(token).getBody();
        }
        catch (Exception e) {
            this.logger.debug("validate is token error ", (Throwable)e);
            return null;
        }
    }

    public boolean isTokenExpired(Date expiration) {
        return expiration.before(new Date());
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public long getExpire() {
        return this.expire;
    }

    public void setExpire(long expire) {
        this.expire = expire;
    }
}

