/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.framework.core.shiro;

import cn.opencodes.framework.autoconfigure.properties.AlphaProperties;
import cn.opencodes.framework.core.service.AlphaService;
import cn.opencodes.framework.core.shiro.AuthcTokenBean;
import cn.opencodes.framework.core.shiro.JwtTokenGen;
import cn.opencodes.framework.core.utils.SpringUtils;
import cn.opencodes.framework.core.utils.WebUtils;
import cn.opencodes.framework.core.vo.UserRoot;
import cn.opencodes.framework.tools.utils.StringUtils;
import cn.opencodes.framework.tools.vo.CoreConst;
import io.jsonwebtoken.Claims;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.web.filter.authc.AuthenticatingFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthcTokenFilter
extends AuthenticatingFilter {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String HEADER_TOKEN_KEY = "token";
    private AlphaService commonSev;
    private JwtTokenGen jwtTokenGen;
    private AlphaProperties props;

    public AuthcTokenFilter(AlphaProperties props) {
        this.props = props;
    }

    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) throws Exception {
        String token = WebUtils.getRequestToken(request);
        UserRoot user = WebUtils.getUser();
        return new AuthcTokenBean(user.getId(), token);
    }

    public void afterCompletion(ServletRequest request, ServletResponse response, Exception exception) throws Exception {
        super.afterCompletion(request, response, exception);
        SecurityUtils.getSubject().logout();
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        HttpServletRequest req = WebUtils.toHttp((ServletRequest)request);
        this.logger.debug("\u62e6\u622aURL\uff1a{}", (Object)WebUtils.getPathWithinApplication((HttpServletRequest)req));
        if (this.isLoginRequest(request, response)) {
            return true;
        }
        if (this.commonSev == null) {
            this.commonSev = SpringUtils.getBean(AlphaService.class);
        }
        if (this.jwtTokenGen == null) {
            this.jwtTokenGen = SpringUtils.getBean(JwtTokenGen.class);
        }
        return false;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        String token = WebUtils.getRequestToken(request);
        if (this.props.getDebug() > 0L && this.props.getActive().equals("dev")) {
            token = this.jwtTokenGen.generateToken(this.props.getDebug());
        }
        if (StringUtils.isBlank((String)token)) {
            WebUtils.write(response, CoreConst.HttpStatus.PARAM_BLANK.value(), "token\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        Claims claims = this.jwtTokenGen.getClaimByToken(token);
        if (claims == null || this.jwtTokenGen.isTokenExpired(claims.getExpiration())) {
            WebUtils.write(response, CoreConst.HttpStatus.TOKEN_EXPIRED.value(), "token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
            return false;
        }
        long userId = Long.parseLong(claims.getSubject());
        UserRoot user = this.commonSev.getUserRootInfo(userId);
        if (user == null || user.isKickout()) {
            WebUtils.write(response, CoreConst.HttpStatus.TOKEN_EXPIRED.value(), "\u60a8\u5df2\u88ab\u8e22\u4e0b\u7ebf\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
            return false;
        }
        WebUtils.setUser(user);
        return this.executeLogin(request, response);
    }
}

