/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.framework.core.shiro;

import cn.opencodes.framework.core.service.AlphaService;
import cn.opencodes.framework.core.utils.SpringUtils;
import cn.opencodes.framework.core.utils.WebUtils;
import cn.opencodes.framework.tools.vo.CoreConst;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthcSecretFilter
extends AccessControlFilter {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String HEADER_APP_KEY = "appKey";
    public static final String HEADER_SECRET_KEY = "appSecret";
    private AlphaService commonSev;

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        if (this.commonSev == null) {
            this.commonSev = SpringUtils.getBean(AlphaService.class);
        }
        return false;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        this.logger.debug("\u62e6\u622aURL\uff1a{}", (Object)this.getPathWithinApplication(request));
        String appKey = WebUtils.getRequestAppKey(request);
        if (StringUtils.isBlank((String)appKey)) {
            WebUtils.write(response, CoreConst.HttpStatus.PARAM_BLANK.value(), "appKey\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        String appSecret = WebUtils.getRequestAppSecret(request);
        if (StringUtils.isBlank((String)appSecret)) {
            WebUtils.write(response, CoreConst.HttpStatus.PARAM_BLANK.value(), "appSecret\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        boolean yes = this.commonSev.checkAppKeyAndSecret(appKey, appSecret);
        if (!yes) {
            WebUtils.write(response, CoreConst.HttpStatus.TOKEN_EXPIRED.value(), "appSecret\u5df2\u5931\u6548");
            return false;
        }
        return true;
    }
}

