/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.framework.core.shiro;

import cn.opencodes.framework.core.service.AlphaService;
import cn.opencodes.framework.core.shiro.AuthcTokenBean;
import cn.opencodes.framework.core.utils.SpringUtils;
import cn.opencodes.framework.core.utils.WebUtils;
import cn.opencodes.framework.core.vo.UserRoot;
import java.util.Set;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;

public class AuthcRealm
extends AuthorizingRealm {
    public boolean supports(AuthenticationToken token) {
        return token instanceof AuthcTokenBean;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        Long userId = (Long)principals.getPrimaryPrincipal();
        Set<String> permsSet = SpringUtils.getBean(AlphaService.class).getUserPermissions(WebUtils.getUser().getSuperAdmin() == 0 ? userId : null);
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        info.setStringPermissions(permsSet);
        return info;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        UserRoot user = WebUtils.getUser();
        if (user == null) {
            long userId = Long.parseLong(token.getPrincipal().toString());
            user = SpringUtils.getBean(AlphaService.class).getUserRootInfo(userId);
        }
        SimpleAuthenticationInfo info = new SimpleAuthenticationInfo((Object)user.getId(), token.getCredentials(), this.getName());
        return info;
    }
}

