/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.framework.core.service;

import cn.opencodes.framework.core.log.LogsHandle;
import cn.opencodes.framework.core.redis.RedisLock;
import cn.opencodes.framework.core.redis.RedisUtils;
import cn.opencodes.framework.core.service.AlphaService;
import cn.opencodes.framework.core.utils.AppUtils;
import cn.opencodes.framework.core.vo.AccessLog;
import cn.opencodes.framework.core.vo.MaliciousLog;
import cn.opencodes.framework.core.vo.OperationLog;
import cn.opencodes.framework.core.vo.SerialNoConfig;
import cn.opencodes.framework.core.vo.UserRoot;
import cn.opencodes.framework.tools.utils.ArrayUtils;
import cn.opencodes.framework.tools.utils.IDUtils;
import cn.opencodes.framework.tools.utils.StringUtils;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractAlphaService
extends LogsHandle
implements AlphaService {
    private static final String CACHE_PERMS_KEY = "shiro:perms:key:";
    private static final String CACHE_DEV_KEY = "shiro:dev:key:";
    private static final String CACHE_USER_KEY = "shiro:user:key:";
    private static final long ONE_HOURS_EXPIRE = 3600L;
    private static final String SERIALNO_KEY = "SerialNo:key:";
    @Autowired
    private RedisUtils redis;

    public abstract Set<String> doLoadPermissions(Long var1);

    public abstract UserRoot doLoadUserRootInfo(Long var1);

    public abstract String doLoadAppDeveloperSalt(String var1);

    public abstract SerialNoConfig doLoadSerialNoCofnig(String var1);

    public abstract void doAccessLogHandle(List<AccessLog> var1);

    public abstract void doMaliciousHandle(List<MaliciousLog> var1);

    public abstract void doOperationHandle(List<OperationLog> var1);

    @Override
    public Set<String> getUserPermissions(Long userId) {
        String key = this.buildUserPermissionsCacheKey(userId == null ? 0L : userId);
        Set<String> permsSet = this.redis.get(key, Set.class);
        if (ArrayUtils.isNotEmpty(permsSet)) {
            return permsSet;
        }
        permsSet = this.doLoadPermissions(userId);
        if (permsSet != null) {
            this.redis.set(key, permsSet, 3600L);
        }
        return permsSet;
    }

    @Override
    public void clearUserPermissionsCache(long userId) {
        String key = this.buildUserPermissionsCacheKey(userId);
        this.redis.delete(key);
    }

    @Override
    public UserRoot getUserRootInfo(long userId) {
        String key = this.buildUserRootInfoCacheKey(userId);
        UserRoot ur = this.redis.get(key, UserRoot.class);
        if (ur != null) {
            return ur;
        }
        ur = this.doLoadUserRootInfo(userId);
        if (ur != null) {
            this.redis.set(key, ur, 3600L);
        }
        return ur;
    }

    @Override
    public void clearUserRootInfoCache(long userId) {
        String key = this.buildUserRootInfoCacheKey(userId);
        this.redis.delete(key);
    }

    @Override
    public boolean checkAppKeyAndSecret(String clientAppKey, String clientAppSecret) {
        String key = this.buildAppKeyCacheKey(clientAppKey);
        String salt = this.redis.get(key, String.class);
        if (StringUtils.isEmpty((String)salt)) {
            return false;
        }
        salt = this.doLoadAppDeveloperSalt(clientAppKey);
        if (StringUtils.isNotBlank((String)salt)) {
            this.redis.set(key, salt, 3600L);
            String serverAppSecret = AppUtils.genAppSecret(clientAppKey, salt);
            return serverAppSecret.equals(clientAppSecret);
        }
        return false;
    }

    @Override
    public void clearAppDeveloperSaltCache(String clientAppKey) {
        String key = this.buildAppKeyCacheKey(clientAppKey);
        this.redis.delete(key);
    }

    @Override
    @RedisLock(value="#p0", keepMills=10000L)
    public String getSerialNo(String buscode) {
        String key = this.buildSerialNoCacheKey(buscode);
        SerialNoConfig cfg = this.redis.get(key, SerialNoConfig.class);
        if (cfg != null) {
            if (cfg.getNo() > cfg.getMaxNo() && cfg.getOverride() == 0) {
                cfg.setNo(-1);
            }
            if (cfg.getCurrentNo() >= cfg.getMaxNo() || cfg.getCurrentNo() % cfg.getStep() == 0) {
                cfg = null;
            }
        }
        if (cfg == null) {
            cfg = this.doLoadSerialNoCofnig(buscode);
        }
        if (cfg == null) {
            return "0";
        }
        if (cfg.getNo() == -1) {
            return "-1";
        }
        cfg.setCurrentNo(1);
        int len = String.valueOf(cfg.getMaxNo()).length();
        String serialNo = IDUtils.buildDateLineNo(cfg.getPrefix(), cfg.getFmt(), cfg.getCurrentNo(), len);
        this.redis.set(key, cfg, 3600L);
        return serialNo;
    }

    @Override
    public void clearSerialNoCache(String buscode) {
        String key = this.buildSerialNoCacheKey(buscode);
        this.redis.delete(key);
    }

    public String buildAppKeyCacheKey(String clientAppKey) {
        return CACHE_DEV_KEY + clientAppKey;
    }

    public String buildUserRootInfoCacheKey(long userId) {
        return CACHE_USER_KEY + userId;
    }

    public String buildUserPermissionsCacheKey(long userId) {
        return CACHE_PERMS_KEY + userId;
    }

    public String buildSerialNoCacheKey(String buscode) {
        return SERIALNO_KEY + buscode;
    }

    @Override
    public <T> void collect(T log, Class<T> requiredType) {
        super.collectLog(log);
    }

    @Override
    public void closeLog() {
        super.closeLog();
    }

    @Override
    public void logsHandle(List<AccessLog> alogs, List<MaliciousLog> mlogs, List<OperationLog> ologs) {
        if (!alogs.isEmpty()) {
            this.doAccessLogHandle(alogs);
        }
        if (!mlogs.isEmpty()) {
            this.doMaliciousHandle(mlogs);
        }
        if (!ologs.isEmpty()) {
            this.doOperationHandle(ologs);
        }
    }
}

