/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.framework.core.redis;

import cn.opencodes.framework.tools.utils.StringUtils;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;

public class RedisUtils {
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private ValueOperations<String, Object> valueOperations;
    public static final long DEFAULT_EXPIRE = 86400L;
    public static final long NOT_EXPIRE = -1L;

    public void set(String key, Object value, long expire) {
        this.valueOperations.set((Object)key, value);
        if (expire != -1L) {
            this.redisTemplate.expire((Object)key, expire, TimeUnit.SECONDS);
        }
    }

    public void set(String key, Object value) {
        this.set(key, value, 86400L);
    }

    public <T> T get(String key, Class<T> clazz, long expire) {
        Object value = this.valueOperations.get((Object)key);
        if (value != null) {
            if (expire != -1L) {
                this.redisTemplate.expire((Object)key, expire, TimeUnit.SECONDS);
            }
            return (T)value;
        }
        return null;
    }

    public <T> T get(String key, Class<T> clazz) {
        return this.get(key, clazz, -1L);
    }

    public void delete(String key) {
        this.redisTemplate.delete((Object)key);
    }

    public Set<String> keys(String pattern) {
        if (StringUtils.isNotBlank((String)pattern)) {
            return this.redisTemplate.keys((Object)pattern);
        }
        return null;
    }

    public RedisAtomicLong getAtomicLong(String key, long liveTime) {
        RedisAtomicLong entityIdCounter = new RedisAtomicLong(key, this.redisTemplate.getConnectionFactory());
        Long increment = entityIdCounter.get();
        if ((null == increment || increment == 1L) && liveTime > 0L) {
            entityIdCounter.expire(liveTime, TimeUnit.SECONDS);
        }
        return entityIdCounter;
    }

    public RedisAtomicLong getAtomicLong(String key) {
        return this.getAtomicLong(key, 0L);
    }
}

