/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.framework.core.redis;

import cn.opencodes.framework.core.redis.RedisDistributedLock;
import cn.opencodes.framework.core.redis.RedisLock;
import cn.opencodes.framework.tools.utils.SpelUtil;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Aspect
public class RedisLockAspect {
    private static final String LOCK_KEY = "RedisLock:";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RedisDistributedLock redisUtils;

    @Pointcut(value="@annotation(cn.opencodes.framework.core.redis.RedisLock)")
    private void lockPoint() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="lockPoint()")
    public Object arround(ProceedingJoinPoint point) throws Throwable {
        Object obj;
        block7: {
            obj = null;
            RLock lock = null;
            boolean success = false;
            try {
                RedisLock lockInfo = this.getLockAnnotation(point);
                String lockKey = this.getRedisKey(point, lockInfo.value());
                lock = this.redisUtils.getLock(lockKey);
                success = this.redisUtils.lock(lock, lockInfo.keepMills(), lockInfo.lockFailMax(), lockInfo.sleepMillis());
                if (success) {
                    this.log.debug("\u8bf7\u6c42\u5f97\u5230\u9501===>{}", (Object)lockKey);
                    obj = point.proceed();
                } else {
                    this.log.debug("\u8bf7\u6c42\u9501\u5931\u8d25===>{}", (Object)lockKey);
                }
                if (lock == null || !success) break block7;
                this.redisUtils.unlock(lock);
            }
            catch (Exception e) {
                try {
                    this.log.error("\u8bf7\u6c42\u9501\u5f02\u5e38:", (Throwable)e);
                    if (lock == null || !success) break block7;
                    this.redisUtils.unlock(lock);
                }
                catch (Throwable throwable) {
                    if (lock != null && success) {
                        this.redisUtils.unlock(lock);
                        this.log.debug("\u91ca\u653e\u8bf7\u6c42\u9501===>{}", (Object)lock.getName());
                    }
                    throw throwable;
                }
                this.log.debug("\u91ca\u653e\u8bf7\u6c42\u9501===>{}", (Object)lock.getName());
            }
            this.log.debug("\u91ca\u653e\u8bf7\u6c42\u9501===>{}", (Object)lock.getName());
        }
        return obj;
    }

    private RedisLock getLockAnnotation(ProceedingJoinPoint point) throws NoSuchMethodException {
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = point.getTarget().getClass().getMethod(signature.getName(), signature.getParameterTypes());
        RedisLock lockInfo = method.getAnnotation(RedisLock.class);
        return lockInfo;
    }

    private String getRedisKey(ProceedingJoinPoint joinPoint, String spel) {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method targetMethod = methodSignature.getMethod();
        Object target = joinPoint.getTarget();
        Object[] arguments = joinPoint.getArgs();
        return LOCK_KEY + SpelUtil.parse(target, spel, targetMethod, arguments);
    }
}

