/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.framework.core.redis;

import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RedisDistributedLock {
    private Logger log = LoggerFactory.getLogger(RedisDistributedLock.class);
    @Autowired
    private RedissonClient redissonClient;

    public boolean lock(RLock lock, long lockTimeout, int retryTimes, long sleepMillis) {
        boolean result = false;
        try {
            result = lock.tryLock(sleepMillis, lockTimeout, TimeUnit.MILLISECONDS);
            while (!result && retryTimes-- > 0) {
                this.log.debug("get redisDistributeLock failed, retrying..." + retryTimes);
                result = lock.tryLock(sleepMillis, lockTimeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void unlock(String key) {
        RLock lock = this.redissonClient.getLock(key);
        lock.unlock();
    }

    public void unlock(RLock lock) {
        lock.unlock();
    }

    public RLock getLock(String key) {
        return this.redissonClient.getLock(key);
    }
}

