/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.framework.core.log;

import cn.opencodes.framework.core.log.SysOperationLog;
import cn.opencodes.framework.core.service.AlphaService;
import cn.opencodes.framework.core.utils.WebUtils;
import cn.opencodes.framework.core.vo.OperationLog;
import cn.opencodes.framework.tools.utils.JsonUtils;
import cn.opencodes.framework.tools.vo.RException;
import java.lang.reflect.Method;
import java.util.Date;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=0)
public class OperationAspect {
    @Autowired
    private AlphaService alphaSev;

    @Pointcut(value="@annotation(cn.opencodes.framework.core.log.SysOperationLog)")
    public void logPointCut() {
    }

    @Around(value="logPointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        long beginTime = System.currentTimeMillis();
        Object result = null;
        int execState = 1;
        String errMsg = null;
        try {
            result = point.proceed();
        }
        catch (Exception e) {
            execState = 0;
            errMsg = e.getMessage();
            throw new RException(errMsg, e);
        }
        finally {
            long time = System.currentTimeMillis() - beginTime;
            this.saveSysLog(point, time, execState, errMsg);
        }
        return result;
    }

    private void saveSysLog(ProceedingJoinPoint joinPoint, long time, int execState, String errMsg) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = joinPoint.getTarget().getClass().getMethod(signature.getName(), signature.getParameterTypes());
        SysOperationLog logAnno = method.getAnnotation(SysOperationLog.class);
        OperationLog operLog = new OperationLog();
        if (logAnno != null) {
            operLog.setOperation(logAnno.value());
        }
        String className = joinPoint.getTarget().getClass().getSimpleName();
        String methodName = signature.getName();
        operLog.setMethod(className + "." + methodName);
        Object[] args = joinPoint.getArgs();
        try {
            String params = JsonUtils.toJson(args[0]);
            operLog.setParams(params);
        }
        catch (Exception exception) {
            // empty catch block
        }
        operLog.setUsername(WebUtils.getUser().getUsername());
        operLog.setTime(time);
        operLog.setCreateDate(new Date());
        operLog.setExecState(execState);
        operLog.setErrMsg(errMsg);
        this.alphaSev.collect(operLog, OperationLog.class);
    }
}

