/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.framework.core.log;

import cn.opencodes.framework.core.vo.AccessLog;
import cn.opencodes.framework.core.vo.MaliciousLog;
import cn.opencodes.framework.core.vo.OperationLog;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LogsHandle {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private ConcurrentLinkedQueue<Object> buffers = new ConcurrentLinkedQueue();
    private int logMax = 10;

    public abstract void logsHandle(List<AccessLog> var1, List<MaliciousLog> var2, List<OperationLog> var3);

    public void collectLog(Object log) {
        this.logger.debug("\u65e5\u5fd7\u52a0\u5165\u7f13\u51b2\u533a\uff1a\n{}", (Object)log.toString());
        this.buffers.offer(log);
        if (this.buffers.size() >= this.logMax && !this.buffers.isEmpty()) {
            this.executorService.submit(new HandleLogRunnable());
        }
    }

    public void closeLog() {
        this.logger.debug("\u5173\u95ed\u65e5\u5fd7\u65f6\u53d1\u73b0\u7f13\u5b58\u533a\u65e5\u5fd7\u672a\u5904\u7406,\u6b63\u5728\u5904\u7406...");
        if (!this.buffers.isEmpty()) {
            this.logsHandle();
        }
        this.logger.debug("\u5904\u7406\u5b8c\u6bd5,\u5df2\u5173\u95ed\u65e5\u5fd7\u5904\u7406\u7ebf\u7a0b\u6c60");
        this.executorService.shutdown();
    }

    private void logsHandle() {
        int len = this.buffers.size();
        this.logger.debug("\u7f13\u51b2\u533a\u5df2\u8fbe\u5230\u9650\u5236\u6570: {}, \u51c6\u5907\u5904\u7406\u65e5\u5fd7", (Object)len);
        ArrayList<AccessLog> alogs = new ArrayList<AccessLog>();
        ArrayList<MaliciousLog> mlogs = new ArrayList<MaliciousLog>();
        ArrayList<OperationLog> ologs = new ArrayList<OperationLog>();
        Object log = null;
        for (int i = 0; i < len; ++i) {
            log = this.buffers.poll();
            if (log instanceof AccessLog) {
                alogs.add((AccessLog)log);
                continue;
            }
            if (log instanceof MaliciousLog) {
                mlogs.add((MaliciousLog)log);
                continue;
            }
            ologs.add((OperationLog)log);
        }
        this.logsHandle(alogs, mlogs, ologs);
        this.logger.debug("\u7f13\u51b2\u533a\u4e2d\u7684\u65e5\u5fd7\u5904\u7406\u5b8c\u6bd5");
    }

    private class HandleLogRunnable
    implements Runnable {
        private HandleLogRunnable() {
        }

        @Override
        public void run() {
            LogsHandle.this.logsHandle();
        }
    }
}

