/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.framework.core.interceptor;

import cn.opencodes.framework.core.service.AlphaService;
import cn.opencodes.framework.core.utils.SpringUtils;
import cn.opencodes.framework.core.utils.WebUtils;
import cn.opencodes.framework.core.vo.MaliciousLog;
import cn.opencodes.framework.core.vo.UserRoot;
import cn.opencodes.framework.tools.utils.JsonUtils;
import cn.opencodes.framework.tools.utils.StringUtils;
import cn.opencodes.framework.tools.vo.CoreConst;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class MaliciousInterceptor
extends HandlerInterceptorAdapter {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Map<String, String> tokenMap = new HashMap<String, String>();
    private RateLimiter limiter;

    public MaliciousInterceptor(RateLimiter limiter) {
        this.limiter = limiter;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            this.logger.debug("\u62e6\u622aURL\uff1a{}", (Object)WebUtils.getPathWithinApplication((HttpServletRequest)request));
            String token = WebUtils.getRequestToken((ServletRequest)request);
            String curMethodName = ((HandlerMethod)handler).getMethod().getName();
            if (this.doMalicious(request, curMethodName, token)) {
                WebUtils.write((ServletResponse)response, CoreConst.HttpStatus.ERROR.value(), "\u7cfb\u7edf\u68c0\u6d4b\u60a8\u7684\u8bf7\u6c42\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
                return false;
            }
        }
        return super.preHandle(request, response, handler);
    }

    private boolean doMalicious(HttpServletRequest request, String curMethodName, String token) {
        boolean yes = false;
        String preMethodName = this.tokenMap.get(token);
        if (StringUtils.isNotBlank((String)preMethodName) && preMethodName.equals(curMethodName) && !this.limiter.tryAcquire(1000L, TimeUnit.MILLISECONDS)) {
            yes = true;
            this.saveMaliciousReqLog(request);
        }
        this.tokenMap.put(token, curMethodName);
        return yes;
    }

    private void saveMaliciousReqLog(HttpServletRequest request) {
        try {
            MaliciousLog log = new MaliciousLog();
            log.setUserAgent(WebUtils.analyticUserAgent(request).toString());
            UserRoot user = WebUtils.getUser();
            log.setUserName(user.getUsername());
            log.setMethod(request.getMethod());
            log.setRequestUrl(request.getServletPath());
            log.setClientHost(WebUtils.getIpAddr());
            log.setParameters(JsonUtils.toJson(request.getParameterMap()));
            log.setCtime(new Date());
            log.setTitle("\u6076\u610f\u8bf7\u6c42\u62e6\u622a");
            SpringUtils.getBean(AlphaService.class).collect(log, MaliciousLog.class);
        }
        catch (Exception e) {
            this.logger.error("\u65e5\u5fd7\u6076\u610f\u62e6\u622a\u5668\u5f02\u5e38:", (Throwable)e);
        }
    }
}

