/*
 * Decompiled with CFR 0.152.
 */
package cn.opencodes.framework.core.interceptor;

import cn.opencodes.framework.core.service.AlphaService;
import cn.opencodes.framework.core.utils.SpringUtils;
import cn.opencodes.framework.core.utils.WebUtils;
import cn.opencodes.framework.core.vo.AccessLog;
import cn.opencodes.framework.core.vo.UserRoot;
import cn.opencodes.framework.tools.utils.DateUtils;
import cn.opencodes.framework.tools.utils.JsonUtils;
import java.text.MessageFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class AccessInterceptor
extends HandlerInterceptorAdapter {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final String ACCESS_TIME_KEY = "access_time_key";

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        long stime = System.currentTimeMillis();
        request.setAttribute("access_time_key", (Object)stime);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        this.saveAccessLog(request, response);
    }

    private void saveAccessLog(HttpServletRequest request, HttpServletResponse response) {
        Long stime = (Long)request.getAttribute("access_time_key");
        Long etime = System.currentTimeMillis();
        String title = MessageFormat.format("{0} - {1}", DateUtils.format(new Date(stime), "mm:ss.SSS"), DateUtils.format(new Date(etime), "mm:ss.SSS"));
        AccessLog log = new AccessLog();
        try {
            UserRoot user = WebUtils.getUser();
            log.setUserName(user.getUsername());
            log.setUserAgent(WebUtils.analyticUserAgent(request).toString());
            log.setCtime(new Date());
            log.setMethod(request.getMethod());
            log.setRequestUrl(request.getServletPath());
            log.setClientHost(WebUtils.getIpAddr(request));
            log.setParameters(JsonUtils.toJson(request.getParameterMap()));
            log.setStatus(response.getStatus());
            log.setConsumeTime(etime - stime);
            log.setTitle(title);
            SpringUtils.getBean(AlphaService.class).collect(log, AccessLog.class);
        }
        catch (Exception e) {
            this.logger.error("\u8bbf\u95ee\u65e5\u5fd7\u62e6\u622a\u5668\u5f02\u5e38:", (Throwable)e);
        }
    }
}

